package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeJobsRequest(jobs: Iterable[String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobsRequest = {
    import DescribeJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobsRequest
      .builder()
      .jobs(jobs.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobsRequest.ReadOnly =
    zio.aws.batch.model.DescribeJobsRequest.wrap(buildAwsValue())
}
object DescribeJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobsRequest =
      zio.aws.batch.model.DescribeJobsRequest(jobs)
    def jobs: List[String]
    def getJobs: ZIO[Any, Nothing, List[String]] = ZIO.succeed(jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobsRequest
  ) extends zio.aws.batch.model.DescribeJobsRequest.ReadOnly {
    override val jobs: List[String] = impl
      .jobs()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobsRequest
  ): zio.aws.batch.model.DescribeJobsRequest.ReadOnly = new Wrapper(impl)
}
