package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EksConfiguration(
    eksClusterArn: String,
    kubernetesNamespace: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksConfiguration = {
    import EksConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksConfiguration
      .builder()
      .eksClusterArn(eksClusterArn: java.lang.String)
      .kubernetesNamespace(kubernetesNamespace: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksConfiguration.ReadOnly =
    zio.aws.batch.model.EksConfiguration.wrap(buildAwsValue())
}
object EksConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksConfiguration =
      zio.aws.batch.model.EksConfiguration(eksClusterArn, kubernetesNamespace)
    def eksClusterArn: String
    def kubernetesNamespace: String
    def getEksClusterArn: ZIO[Any, Nothing, String] = ZIO.succeed(eksClusterArn)
    def getKubernetesNamespace: ZIO[Any, Nothing, String] =
      ZIO.succeed(kubernetesNamespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksConfiguration
  ) extends zio.aws.batch.model.EksConfiguration.ReadOnly {
    override val eksClusterArn: String = impl.eksClusterArn(): String
    override val kubernetesNamespace: String =
      impl.kubernetesNamespace(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksConfiguration
  ): zio.aws.batch.model.EksConfiguration.ReadOnly = new Wrapper(impl)
}
