package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainer(
    name: Optional[String] = Optional.Absent,
    image: String,
    imagePullPolicy: Optional[String] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    args: Optional[Iterable[String]] = Optional.Absent,
    env: Optional[
      Iterable[zio.aws.batch.model.EksContainerEnvironmentVariable]
    ] = Optional.Absent,
    resources: Optional[zio.aws.batch.model.EksContainerResourceRequirements] =
      Optional.Absent,
    volumeMounts: Optional[
      Iterable[zio.aws.batch.model.EksContainerVolumeMount]
    ] = Optional.Absent,
    securityContext: Optional[zio.aws.batch.model.EksContainerSecurityContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainer = {
    import EksContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainer
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .image(image: java.lang.String)
      .optionallyWith(imagePullPolicy.map(value => value: java.lang.String))(
        _.imagePullPolicy
      )
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .optionallyWith(
        env.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.env)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(
        volumeMounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeMounts)
      .optionallyWith(securityContext.map(value => value.buildAwsValue()))(
        _.securityContext
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainer.ReadOnly =
    zio.aws.batch.model.EksContainer.wrap(buildAwsValue())
}
object EksContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainer =
      zio.aws.batch.model.EksContainer(
        name.map(value => value),
        image,
        imagePullPolicy.map(value => value),
        command.map(value => value),
        args.map(value => value),
        env.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resources.map(value => value.asEditable),
        volumeMounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityContext.map(value => value.asEditable)
      )
    def name: Optional[String]
    def image: String
    def imagePullPolicy: Optional[String]
    def command: Optional[List[String]]
    def args: Optional[List[String]]
    def env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ]
    def resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ]
    def volumeMounts
        : Optional[List[zio.aws.batch.model.EksContainerVolumeMount.ReadOnly]]
    def securityContext
        : Optional[zio.aws.batch.model.EksContainerSecurityContext.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, Nothing, String] = ZIO.succeed(image)
    def getImagePullPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imagePullPolicy", imagePullPolicy)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
    def getEnv: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField("env", env)
    def getResources: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = AwsError.unwrapOptionField("resources", resources)
    def getVolumeMounts: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerVolumeMount.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeMounts", volumeMounts)
    def getSecurityContext: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksContainerSecurityContext.ReadOnly
    ] = AwsError.unwrapOptionField("securityContext", securityContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainer
  ) extends zio.aws.batch.model.EksContainer.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val image: String = impl.image(): String
    override val imagePullPolicy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imagePullPolicy())
      .map(value => value: String)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val args: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.env())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.EksContainerEnvironmentVariable.wrap(item)
        }.toList
      )
    override val resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        zio.aws.batch.model.EksContainerResourceRequirements.wrap(value)
      )
    override val volumeMounts
        : Optional[List[zio.aws.batch.model.EksContainerVolumeMount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeMounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksContainerVolumeMount.wrap(item)
          }.toList
        )
    override val securityContext
        : Optional[zio.aws.batch.model.EksContainerSecurityContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityContext())
        .map(value =>
          zio.aws.batch.model.EksContainerSecurityContext.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainer
  ): zio.aws.batch.model.EksContainer.ReadOnly = new Wrapper(impl)
}
