package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerDetail(
    name: Optional[String] = Optional.Absent,
    image: Optional[String] = Optional.Absent,
    imagePullPolicy: Optional[String] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    args: Optional[Iterable[String]] = Optional.Absent,
    env: Optional[
      Iterable[zio.aws.batch.model.EksContainerEnvironmentVariable]
    ] = Optional.Absent,
    resources: Optional[zio.aws.batch.model.EksContainerResourceRequirements] =
      Optional.Absent,
    exitCode: Optional[Integer] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    volumeMounts: Optional[
      Iterable[zio.aws.batch.model.EksContainerVolumeMount]
    ] = Optional.Absent,
    securityContext: Optional[zio.aws.batch.model.EksContainerSecurityContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerDetail = {
    import EksContainerDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerDetail
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(imagePullPolicy.map(value => value: java.lang.String))(
        _.imagePullPolicy
      )
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .optionallyWith(
        env.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.env)
      .optionallyWith(resources.map(value => value.buildAwsValue()))(
        _.resources
      )
      .optionallyWith(exitCode.map(value => value: java.lang.Integer))(
        _.exitCode
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        volumeMounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeMounts)
      .optionallyWith(securityContext.map(value => value.buildAwsValue()))(
        _.securityContext
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainerDetail.ReadOnly =
    zio.aws.batch.model.EksContainerDetail.wrap(buildAwsValue())
}
object EksContainerDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerDetail =
      zio.aws.batch.model.EksContainerDetail(
        name.map(value => value),
        image.map(value => value),
        imagePullPolicy.map(value => value),
        command.map(value => value),
        args.map(value => value),
        env.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resources.map(value => value.asEditable),
        exitCode.map(value => value),
        reason.map(value => value),
        volumeMounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityContext.map(value => value.asEditable)
      )
    def name: Optional[String]
    def image: Optional[String]
    def imagePullPolicy: Optional[String]
    def command: Optional[List[String]]
    def args: Optional[List[String]]
    def env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ]
    def resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ]
    def exitCode: Optional[Integer]
    def reason: Optional[String]
    def volumeMounts
        : Optional[List[zio.aws.batch.model.EksContainerVolumeMount.ReadOnly]]
    def securityContext
        : Optional[zio.aws.batch.model.EksContainerSecurityContext.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getImagePullPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imagePullPolicy", imagePullPolicy)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
    def getEnv: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly
    ]] = AwsError.unwrapOptionField("env", env)
    def getResources: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = AwsError.unwrapOptionField("resources", resources)
    def getExitCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getVolumeMounts: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerVolumeMount.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeMounts", volumeMounts)
    def getSecurityContext: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EksContainerSecurityContext.ReadOnly
    ] = AwsError.unwrapOptionField("securityContext", securityContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerDetail
  ) extends zio.aws.batch.model.EksContainerDetail.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val imagePullPolicy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imagePullPolicy())
      .map(value => value: String)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val args: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val env: Optional[
      List[zio.aws.batch.model.EksContainerEnvironmentVariable.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.env())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.EksContainerEnvironmentVariable.wrap(item)
        }.toList
      )
    override val resources: Optional[
      zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        zio.aws.batch.model.EksContainerResourceRequirements.wrap(value)
      )
    override val exitCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: Integer)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val volumeMounts
        : Optional[List[zio.aws.batch.model.EksContainerVolumeMount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeMounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksContainerVolumeMount.wrap(item)
          }.toList
        )
    override val securityContext
        : Optional[zio.aws.batch.model.EksContainerSecurityContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityContext())
        .map(value =>
          zio.aws.batch.model.EksContainerSecurityContext.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerDetail
  ): zio.aws.batch.model.EksContainerDetail.ReadOnly = new Wrapper(impl)
}
