package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerVolumeMount(
    name: Optional[String] = Optional.Absent,
    mountPath: Optional[String] = Optional.Absent,
    readOnly: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerVolumeMount = {
    import EksContainerVolumeMount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerVolumeMount
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(mountPath.map(value => value: java.lang.String))(
        _.mountPath
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainerVolumeMount.ReadOnly =
    zio.aws.batch.model.EksContainerVolumeMount.wrap(buildAwsValue())
}
object EksContainerVolumeMount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerVolumeMount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerVolumeMount =
      zio.aws.batch.model.EksContainerVolumeMount(
        name.map(value => value),
        mountPath.map(value => value),
        readOnly.map(value => value)
      )
    def name: Optional[String]
    def mountPath: Optional[String]
    def readOnly: Optional[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMountPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mountPath", mountPath)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerVolumeMount
  ) extends zio.aws.batch.model.EksContainerVolumeMount.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val mountPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mountPath())
      .map(value => value: String)
    override val readOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readOnly())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerVolumeMount
  ): zio.aws.batch.model.EksContainerVolumeMount.ReadOnly = new Wrapper(impl)
}
