package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksMetadata(
    labels: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksMetadata = {
    import EksMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksMetadata
      .builder()
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksMetadata.ReadOnly =
    zio.aws.batch.model.EksMetadata.wrap(buildAwsValue())
}
object EksMetadata {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.EksMetadata] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksMetadata =
      zio.aws.batch.model.EksMetadata(labels.map(value => value))
    def labels: Optional[Map[String, String]]
    def getLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksMetadata
  ) extends zio.aws.batch.model.EksMetadata.ReadOnly {
    override val labels: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksMetadata
  ): zio.aws.batch.model.EksMetadata.ReadOnly = new Wrapper(impl)
}
