package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksPodPropertiesDetail(
    serviceAccountName: Optional[String] = Optional.Absent,
    hostNetwork: Optional[Boolean] = Optional.Absent,
    dnsPolicy: Optional[String] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.batch.model.EksContainerDetail]] =
      Optional.Absent,
    volumes: Optional[Iterable[zio.aws.batch.model.EksVolume]] =
      Optional.Absent,
    podName: Optional[String] = Optional.Absent,
    nodeName: Optional[String] = Optional.Absent,
    metadata: Optional[zio.aws.batch.model.EksMetadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksPodPropertiesDetail = {
    import EksPodPropertiesDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksPodPropertiesDetail
      .builder()
      .optionallyWith(serviceAccountName.map(value => value: java.lang.String))(
        _.serviceAccountName
      )
      .optionallyWith(hostNetwork.map(value => value: java.lang.Boolean))(
        _.hostNetwork
      )
      .optionallyWith(dnsPolicy.map(value => value: java.lang.String))(
        _.dnsPolicy
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(podName.map(value => value: java.lang.String))(_.podName)
      .optionallyWith(nodeName.map(value => value: java.lang.String))(
        _.nodeName
      )
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly =
    zio.aws.batch.model.EksPodPropertiesDetail.wrap(buildAwsValue())
}
object EksPodPropertiesDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksPodPropertiesDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksPodPropertiesDetail =
      zio.aws.batch.model.EksPodPropertiesDetail(
        serviceAccountName.map(value => value),
        hostNetwork.map(value => value),
        dnsPolicy.map(value => value),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        podName.map(value => value),
        nodeName.map(value => value),
        metadata.map(value => value.asEditable)
      )
    def serviceAccountName: Optional[String]
    def hostNetwork: Optional[Boolean]
    def dnsPolicy: Optional[String]
    def containers
        : Optional[List[zio.aws.batch.model.EksContainerDetail.ReadOnly]]
    def volumes: Optional[List[zio.aws.batch.model.EksVolume.ReadOnly]]
    def podName: Optional[String]
    def nodeName: Optional[String]
    def metadata: Optional[zio.aws.batch.model.EksMetadata.ReadOnly]
    def getServiceAccountName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccountName", serviceAccountName)
    def getHostNetwork: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hostNetwork", hostNetwork)
    def getDnsPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsPolicy", dnsPolicy)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.batch.model.EksVolume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getPodName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("podName", podName)
    def getNodeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeName", nodeName)
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.batch.model.EksMetadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksPodPropertiesDetail
  ) extends zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly {
    override val serviceAccountName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccountName())
      .map(value => value: String)
    override val hostNetwork: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hostNetwork())
      .map(value => value: Boolean)
    override val dnsPolicy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsPolicy())
      .map(value => value: String)
    override val containers
        : Optional[List[zio.aws.batch.model.EksContainerDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksContainerDetail.wrap(item)
          }.toList
        )
    override val volumes
        : Optional[List[zio.aws.batch.model.EksVolume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksVolume.wrap(item)
          }.toList
        )
    override val podName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.podName())
      .map(value => value: String)
    override val nodeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeName())
      .map(value => value: String)
    override val metadata: Optional[zio.aws.batch.model.EksMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.batch.model.EksMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksPodPropertiesDetail
  ): zio.aws.batch.model.EksPodPropertiesDetail.ReadOnly = new Wrapper(impl)
}
