package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksProperties(
    podProperties: Optional[zio.aws.batch.model.EksPodProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksProperties = {
    import EksProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksProperties
      .builder()
      .optionallyWith(podProperties.map(value => value.buildAwsValue()))(
        _.podProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksProperties.ReadOnly =
    zio.aws.batch.model.EksProperties.wrap(buildAwsValue())
}
object EksProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksProperties = zio.aws.batch.model
      .EksProperties(podProperties.map(value => value.asEditable))
    def podProperties: Optional[zio.aws.batch.model.EksPodProperties.ReadOnly]
    def getPodProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.EksPodProperties.ReadOnly] =
      AwsError.unwrapOptionField("podProperties", podProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksProperties
  ) extends zio.aws.batch.model.EksProperties.ReadOnly {
    override val podProperties
        : Optional[zio.aws.batch.model.EksPodProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.podProperties())
        .map(value => zio.aws.batch.model.EksPodProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksProperties
  ): zio.aws.batch.model.EksProperties.ReadOnly = new Wrapper(impl)
}
