package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait JobDefinitionType {
  def unwrap: software.amazon.awssdk.services.batch.model.JobDefinitionType
}
object JobDefinitionType {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.JobDefinitionType
  ): zio.aws.batch.model.JobDefinitionType = value match {
    case software.amazon.awssdk.services.batch.model.JobDefinitionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.JobDefinitionType.CONTAINER =>
      val r = container
      r
    case software.amazon.awssdk.services.batch.model.JobDefinitionType.MULTINODE =>
      val r = multinode
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.JobDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.JobDefinitionType =
      software.amazon.awssdk.services.batch.model.JobDefinitionType.UNKNOWN_TO_SDK_VERSION
  }
  case object container extends zio.aws.batch.model.JobDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.JobDefinitionType =
      software.amazon.awssdk.services.batch.model.JobDefinitionType.CONTAINER
  }
  case object multinode extends zio.aws.batch.model.JobDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.JobDefinitionType =
      software.amazon.awssdk.services.batch.model.JobDefinitionType.MULTINODE
  }
}
