package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.batch.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.JobStatus
  ): zio.aws.batch.model.JobStatus = value match {
    case software.amazon.awssdk.services.batch.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.RUNNABLE =>
      val r = RUNNABLE
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.batch.model.JobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.SUBMITTED
  }
  case object PENDING extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.PENDING
  }
  case object RUNNABLE extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.RUNNABLE
  }
  case object STARTING extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.STARTING
  }
  case object RUNNING extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.batch.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.batch.model.JobStatus =
      software.amazon.awssdk.services.batch.model.JobStatus.FAILED
  }
}
