package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSchedulingPoliciesRequest(
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest = {
    import ListSchedulingPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly =
    zio.aws.batch.model.ListSchedulingPoliciesRequest.wrap(buildAwsValue())
}
object ListSchedulingPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListSchedulingPoliciesRequest =
      zio.aws.batch.model.ListSchedulingPoliciesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ) extends zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly {
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest
  ): zio.aws.batch.model.ListSchedulingPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
