package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSchedulingPoliciesResponse(
    schedulingPolicies: Optional[
      Iterable[zio.aws.batch.model.SchedulingPolicyListingDetail]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse = {
    import ListSchedulingPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
      .builder()
      .optionallyWith(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schedulingPolicies)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly =
    zio.aws.batch.model.ListSchedulingPoliciesResponse.wrap(buildAwsValue())
}
object ListSchedulingPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListSchedulingPoliciesResponse =
      zio.aws.batch.model.ListSchedulingPoliciesResponse(
        schedulingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def schedulingPolicies: Optional[
      List[zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getSchedulingPolicies: ZIO[Any, AwsError, List[
      zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("schedulingPolicies", schedulingPolicies)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ) extends zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly {
    override val schedulingPolicies: Optional[
      List[zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.SchedulingPolicyListingDetail.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse
  ): zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
