package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RegisterJobDefinitionResponse(
    jobDefinitionName: String,
    jobDefinitionArn: String,
    revision: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse = {
    import RegisterJobDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse
      .builder()
      .jobDefinitionName(jobDefinitionName: java.lang.String)
      .jobDefinitionArn(jobDefinitionArn: java.lang.String)
      .revision(revision: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly =
    zio.aws.batch.model.RegisterJobDefinitionResponse.wrap(buildAwsValue())
}
object RegisterJobDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.RegisterJobDefinitionResponse =
      zio.aws.batch.model.RegisterJobDefinitionResponse(
        jobDefinitionName,
        jobDefinitionArn,
        revision
      )
    def jobDefinitionName: String
    def jobDefinitionArn: String
    def revision: Integer
    def getJobDefinitionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionName)
    def getJobDefinitionArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionArn)
    def getRevision: ZIO[Any, Nothing, Integer] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse
  ) extends zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly {
    override val jobDefinitionName: String = impl.jobDefinitionName(): String
    override val jobDefinitionArn: String = impl.jobDefinitionArn(): String
    override val revision: Integer = impl.revision(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse
  ): zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly = new Wrapper(
    impl
  )
}
