package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResourceRequirement(
    value: String,
    `type`: zio.aws.batch.model.ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ResourceRequirement = {
    import ResourceRequirement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ResourceRequirement
      .builder()
      .value(value: java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ResourceRequirement.ReadOnly =
    zio.aws.batch.model.ResourceRequirement.wrap(buildAwsValue())
}
object ResourceRequirement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ResourceRequirement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ResourceRequirement =
      zio.aws.batch.model.ResourceRequirement(value, `type`)
    def value: String
    def `type`: zio.aws.batch.model.ResourceType
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getType: ZIO[Any, Nothing, zio.aws.batch.model.ResourceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ResourceRequirement
  ) extends zio.aws.batch.model.ResourceRequirement.ReadOnly {
    override val value: String = impl.value(): String
    override val `type`: zio.aws.batch.model.ResourceType =
      zio.aws.batch.model.ResourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ResourceRequirement
  ): zio.aws.batch.model.ResourceRequirement.ReadOnly = new Wrapper(impl)
}
