package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.batch.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.ResourceType
  ): zio.aws.batch.model.ResourceType = value match {
    case software.amazon.awssdk.services.batch.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.ResourceType.GPU =>
      val r = GPU
      r
    case software.amazon.awssdk.services.batch.model.ResourceType.VCPU =>
      val r = VCPU
      r
    case software.amazon.awssdk.services.batch.model.ResourceType.MEMORY =>
      val r = MEMORY
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ResourceType =
      software.amazon.awssdk.services.batch.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object GPU extends zio.aws.batch.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ResourceType =
      software.amazon.awssdk.services.batch.model.ResourceType.GPU
  }
  case object VCPU extends zio.aws.batch.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ResourceType =
      software.amazon.awssdk.services.batch.model.ResourceType.VCPU
  }
  case object MEMORY extends zio.aws.batch.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.ResourceType =
      software.amazon.awssdk.services.batch.model.ResourceType.MEMORY
  }
}
