package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RetryStrategy(
    attempts: Optional[Integer] = Optional.Absent,
    evaluateOnExit: Optional[Iterable[zio.aws.batch.model.EvaluateOnExit]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.RetryStrategy = {
    import RetryStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.RetryStrategy
      .builder()
      .optionallyWith(attempts.map(value => value: java.lang.Integer))(
        _.attempts
      )
      .optionallyWith(
        evaluateOnExit.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluateOnExit)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.RetryStrategy.ReadOnly =
    zio.aws.batch.model.RetryStrategy.wrap(buildAwsValue())
}
object RetryStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.RetryStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.RetryStrategy =
      zio.aws.batch.model.RetryStrategy(
        attempts.map(value => value),
        evaluateOnExit.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attempts: Optional[Integer]
    def evaluateOnExit
        : Optional[List[zio.aws.batch.model.EvaluateOnExit.ReadOnly]]
    def getAttempts: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("attempts", attempts)
    def getEvaluateOnExit: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EvaluateOnExit.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluateOnExit", evaluateOnExit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.RetryStrategy
  ) extends zio.aws.batch.model.RetryStrategy.ReadOnly {
    override val attempts: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.attempts())
      .map(value => value: Integer)
    override val evaluateOnExit
        : Optional[List[zio.aws.batch.model.EvaluateOnExit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluateOnExit())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EvaluateOnExit.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.RetryStrategy
  ): zio.aws.batch.model.RetryStrategy.ReadOnly = new Wrapper(impl)
}
