package zio.aws.bedrock
import zio.aws.bedrock.model.GetGuardrailResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.bedrock.model.{
  ListModelCustomizationJobsResponse,
  ListInferenceProfilesRequest,
  ListInferenceProfilesResponse,
  GetEvaluationJobRequest,
  StopEvaluationJobRequest,
  ListModelInvocationJobsResponse,
  CreateProvisionedModelThroughputResponse,
  ListCustomModelsResponse,
  ListProvisionedModelThroughputsResponse,
  ModelCustomizationJobSummary,
  ListModelImportJobsResponse,
  ListModelCopyJobsRequest,
  DeleteGuardrailRequest,
  CreateModelImportJobRequest,
  DeleteCustomModelRequest,
  CreateModelCustomizationJobResponse,
  CustomModelSummary,
  CreateModelCopyJobRequest,
  GetModelCustomizationJobRequest,
  GetModelInvocationLoggingConfigurationResponse,
  ListModelCopyJobsResponse,
  StopModelInvocationJobRequest,
  UpdateProvisionedModelThroughputResponse,
  ListGuardrailsRequest,
  DeleteProvisionedModelThroughputRequest,
  CreateGuardrailRequest,
  UpdateGuardrailRequest,
  PutModelInvocationLoggingConfigurationResponse,
  CreateModelImportJobResponse,
  StopModelCustomizationJobResponse,
  DeleteModelInvocationLoggingConfigurationRequest,
  GetImportedModelResponse,
  GetCustomModelResponse,
  ListGuardrailsResponse,
  CreateProvisionedModelThroughputRequest,
  BatchDeleteEvaluationJobRequest,
  ListTagsForResourceRequest,
  GetInferenceProfileResponse,
  GetModelInvocationLoggingConfigurationRequest,
  GetImportedModelRequest,
  StopEvaluationJobResponse,
  GetInferenceProfileRequest,
  BatchDeleteEvaluationJobResponse,
  CreateEvaluationJobResponse,
  GetModelCopyJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  PutModelInvocationLoggingConfigurationRequest,
  CreateGuardrailVersionRequest,
  CreateModelInvocationJobResponse,
  ProvisionedModelSummary,
  CreateModelCopyJobResponse,
  ListModelCustomizationJobsRequest,
  ListModelImportJobsRequest,
  ModelCopyJobSummary,
  GetModelInvocationJobRequest,
  CreateGuardrailResponse,
  DeleteGuardrailResponse,
  StopModelCustomizationJobRequest,
  ListProvisionedModelThroughputsRequest,
  ListEvaluationJobsRequest,
  EvaluationSummary,
  GetGuardrailRequest,
  ModelInvocationJobSummary,
  GetFoundationModelRequest,
  ListFoundationModelsRequest,
  UntagResourceRequest,
  DeleteImportedModelResponse,
  GetModelCopyJobRequest,
  GetModelImportJobRequest,
  ListModelInvocationJobsRequest,
  DeleteModelInvocationLoggingConfigurationResponse,
  GetProvisionedModelThroughputRequest,
  InferenceProfileSummary,
  ListImportedModelsRequest,
  UpdateGuardrailResponse,
  UpdateProvisionedModelThroughputRequest,
  GetCustomModelRequest,
  ModelImportJobSummary,
  ListImportedModelsResponse,
  GuardrailSummary,
  CreateEvaluationJobRequest,
  CreateModelInvocationJobRequest,
  GetGuardrailResponse,
  GetModelCustomizationJobResponse,
  GetModelInvocationJobResponse,
  ListFoundationModelsResponse,
  TagResourceResponse,
  DeleteImportedModelRequest,
  CreateGuardrailVersionResponse,
  ListCustomModelsRequest,
  GetFoundationModelResponse,
  GetEvaluationJobResponse,
  CreateModelCustomizationJobRequest,
  GetProvisionedModelThroughputResponse,
  TagResourceRequest,
  DeleteCustomModelResponse,
  DeleteProvisionedModelThroughputResponse,
  ImportedModelSummary,
  GetModelImportJobResponse,
  StopModelInvocationJobResponse,
  ListEvaluationJobsResponse
}
import software.amazon.awssdk.services.bedrock.paginators.{
  ListGuardrailsPublisher,
  ListModelImportJobsPublisher,
  ListEvaluationJobsPublisher,
  ListModelInvocationJobsPublisher,
  ListModelCopyJobsPublisher,
  ListCustomModelsPublisher,
  ListInferenceProfilesPublisher,
  ListImportedModelsPublisher,
  ListModelCustomizationJobsPublisher,
  ListProvisionedModelThroughputsPublisher
}
import software.amazon.awssdk.services.bedrock.{
  BedrockAsyncClientBuilder,
  BedrockAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Bedrock extends AspectSupport[Bedrock] {
  val api: BedrockAsyncClient
  def getGuardrail(
      request: zio.aws.bedrock.model.GetGuardrailRequest
  ): IO[AwsError, ReadOnly]
  def listFoundationModels(
      request: zio.aws.bedrock.model.ListFoundationModelsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly]
  def getInferenceProfile(
      request: zio.aws.bedrock.model.GetInferenceProfileRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly]
  def createModelInvocationJob(
      request: zio.aws.bedrock.model.CreateModelInvocationJobRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly
  ]
  def deleteCustomModel(
      request: zio.aws.bedrock.model.DeleteCustomModelRequest
  ): IO[AwsError, zio.aws.bedrock.model.DeleteCustomModelResponse.ReadOnly]
  def listCustomModels(
      request: zio.aws.bedrock.model.ListCustomModelsRequest
  ): ZStream[Any, AwsError, zio.aws.bedrock.model.CustomModelSummary.ReadOnly]
  def listCustomModelsPaginated(
      request: zio.aws.bedrock.model.ListCustomModelsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListCustomModelsResponse.ReadOnly]
  def listModelInvocationJobs(
      request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
  ]
  def listModelInvocationJobsPaginated(
      request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly
  ]
  def createModelImportJob(
      request: zio.aws.bedrock.model.CreateModelImportJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly]
  def createEvaluationJob(
      request: zio.aws.bedrock.model.CreateEvaluationJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly]
  def listEvaluationJobs(
      request: zio.aws.bedrock.model.ListEvaluationJobsRequest
  ): ZStream[Any, AwsError, zio.aws.bedrock.model.EvaluationSummary.ReadOnly]
  def listEvaluationJobsPaginated(
      request: zio.aws.bedrock.model.ListEvaluationJobsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly]
  def getModelImportJob(
      request: zio.aws.bedrock.model.GetModelImportJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly]
  def deleteImportedModel(
      request: zio.aws.bedrock.model.DeleteImportedModelRequest
  ): IO[AwsError, zio.aws.bedrock.model.DeleteImportedModelResponse.ReadOnly]
  def getProvisionedModelThroughput(
      request: zio.aws.bedrock.model.GetProvisionedModelThroughputRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly
  ]
  def createModelCopyJob(
      request: zio.aws.bedrock.model.CreateModelCopyJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly]
  def createGuardrailVersion(
      request: zio.aws.bedrock.model.CreateGuardrailVersionRequest
  ): IO[AwsError, zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly]
  def deleteProvisionedModelThroughput(
      request: zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.ReadOnly
  ]
  def createProvisionedModelThroughput(
      request: zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly
  ]
  def getFoundationModel(
      request: zio.aws.bedrock.model.GetFoundationModelRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly]
  def updateProvisionedModelThroughput(
      request: zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.ReadOnly
  ]
  def getModelCopyJob(
      request: zio.aws.bedrock.model.GetModelCopyJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetModelCopyJobResponse.ReadOnly]
  def createGuardrail(
      request: zio.aws.bedrock.model.CreateGuardrailRequest
  ): IO[AwsError, zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly]
  def getCustomModel(
      request: zio.aws.bedrock.model.GetCustomModelRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly]
  def getModelCustomizationJob(
      request: zio.aws.bedrock.model.GetModelCustomizationJobRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly
  ]
  def deleteModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.ReadOnly
  ]
  def updateGuardrail(
      request: zio.aws.bedrock.model.UpdateGuardrailRequest
  ): IO[AwsError, zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly]
  def listGuardrails(
      request: zio.aws.bedrock.model.ListGuardrailsRequest
  ): ZStream[Any, AwsError, zio.aws.bedrock.model.GuardrailSummary.ReadOnly]
  def listGuardrailsPaginated(
      request: zio.aws.bedrock.model.ListGuardrailsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.bedrock.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.bedrock.model.UntagResourceResponse.ReadOnly]
  def createModelCustomizationJob(
      request: zio.aws.bedrock.model.CreateModelCustomizationJobRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly
  ]
  def getImportedModel(
      request: zio.aws.bedrock.model.GetImportedModelRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly]
  def listProvisionedModelThroughputs(
      request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
  ]
  def listProvisionedModelThroughputsPaginated(
      request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly
  ]
  def getModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly
  ]
  def deleteGuardrail(
      request: zio.aws.bedrock.model.DeleteGuardrailRequest
  ): IO[AwsError, zio.aws.bedrock.model.DeleteGuardrailResponse.ReadOnly]
  def getEvaluationJob(
      request: zio.aws.bedrock.model.GetEvaluationJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.bedrock.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListTagsForResourceResponse.ReadOnly]
  def stopEvaluationJob(
      request: zio.aws.bedrock.model.StopEvaluationJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.StopEvaluationJobResponse.ReadOnly]
  def listImportedModels(
      request: zio.aws.bedrock.model.ListImportedModelsRequest
  ): ZStream[Any, AwsError, zio.aws.bedrock.model.ImportedModelSummary.ReadOnly]
  def listImportedModelsPaginated(
      request: zio.aws.bedrock.model.ListImportedModelsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly]
  def tagResource(
      request: zio.aws.bedrock.model.TagResourceRequest
  ): IO[AwsError, zio.aws.bedrock.model.TagResourceResponse.ReadOnly]
  def listModelCustomizationJobs(
      request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
  ]
  def listModelCustomizationJobsPaginated(
      request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly
  ]
  def listModelCopyJobs(
      request: zio.aws.bedrock.model.ListModelCopyJobsRequest
  ): ZStream[Any, AwsError, zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly]
  def listModelCopyJobsPaginated(
      request: zio.aws.bedrock.model.ListModelCopyJobsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly]
  def listInferenceProfiles(
      request: zio.aws.bedrock.model.ListInferenceProfilesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
  ]
  def listInferenceProfilesPaginated(
      request: zio.aws.bedrock.model.ListInferenceProfilesRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly]
  def stopModelCustomizationJob(
      request: zio.aws.bedrock.model.StopModelCustomizationJobRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.StopModelCustomizationJobResponse.ReadOnly
  ]
  def listModelImportJobs(
      request: zio.aws.bedrock.model.ListModelImportJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
  ]
  def listModelImportJobsPaginated(
      request: zio.aws.bedrock.model.ListModelImportJobsRequest
  ): IO[AwsError, zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly]
  def batchDeleteEvaluationJob(
      request: zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly
  ]
  def getModelInvocationJob(
      request: zio.aws.bedrock.model.GetModelInvocationJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly]
  def stopModelInvocationJob(
      request: zio.aws.bedrock.model.StopModelInvocationJobRequest
  ): IO[AwsError, zio.aws.bedrock.model.StopModelInvocationJobResponse.ReadOnly]
  def putModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.ReadOnly
  ]
}
object Bedrock {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Bedrock] = customized(
    identity
  )
  def customized(
      customization: BedrockAsyncClientBuilder => BedrockAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Bedrock] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BedrockAsyncClientBuilder => BedrockAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Bedrock] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BedrockAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[BedrockAsyncClient, BedrockAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[BedrockAsyncClient, BedrockAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new BedrockImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class BedrockImpl[R](
      override val api: BedrockAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Bedrock
      with AwsServiceBase[R] {
    override val serviceName: String = "Bedrock"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BedrockImpl[R1] = new BedrockImpl(api, newAspect, r)
    def getGuardrail(
        request: zio.aws.bedrock.model.GetGuardrailRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetGuardrailRequest, GetGuardrailResponse](
        "getGuardrail",
        api.getGuardrail
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetGuardrailResponse.wrap)
        .provideEnvironment(r)
    def listFoundationModels(
        request: zio.aws.bedrock.model.ListFoundationModelsRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFoundationModelsRequest,
      ListFoundationModelsResponse
    ]("listFoundationModels", api.listFoundationModels)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.ListFoundationModelsResponse.wrap)
      .provideEnvironment(r)
    def getInferenceProfile(
        request: zio.aws.bedrock.model.GetInferenceProfileRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      GetInferenceProfileRequest,
      GetInferenceProfileResponse
    ]("getInferenceProfile", api.getInferenceProfile)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.GetInferenceProfileResponse.wrap)
      .provideEnvironment(r)
    def createModelInvocationJob(
        request: zio.aws.bedrock.model.CreateModelInvocationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateModelInvocationJobRequest,
      CreateModelInvocationJobResponse
    ]("createModelInvocationJob", api.createModelInvocationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.CreateModelInvocationJobResponse.wrap)
      .provideEnvironment(r)
    def deleteCustomModel(
        request: zio.aws.bedrock.model.DeleteCustomModelRequest
    ): IO[AwsError, zio.aws.bedrock.model.DeleteCustomModelResponse.ReadOnly] =
      asyncRequestResponse[DeleteCustomModelRequest, DeleteCustomModelResponse](
        "deleteCustomModel",
        api.deleteCustomModel
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.DeleteCustomModelResponse.wrap)
        .provideEnvironment(r)
    def listCustomModels(
        request: zio.aws.bedrock.model.ListCustomModelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.CustomModelSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListCustomModelsRequest,
      CustomModelSummary,
      ListCustomModelsPublisher
    ]("listCustomModels", api.listCustomModelsPaginator, _.modelSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.bedrock.model.CustomModelSummary.wrap(item))
      .provideEnvironment(r)
    def listCustomModelsPaginated(
        request: zio.aws.bedrock.model.ListCustomModelsRequest
    ): IO[AwsError, zio.aws.bedrock.model.ListCustomModelsResponse.ReadOnly] =
      asyncRequestResponse[ListCustomModelsRequest, ListCustomModelsResponse](
        "listCustomModels",
        api.listCustomModels
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.ListCustomModelsResponse.wrap)
        .provideEnvironment(r)
    def listModelInvocationJobs(
        request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListModelInvocationJobsRequest,
      ModelInvocationJobSummary,
      ListModelInvocationJobsPublisher
    ](
      "listModelInvocationJobs",
      api.listModelInvocationJobsPaginator,
      _.invocationJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.ModelInvocationJobSummary.wrap(item))
      .provideEnvironment(r)
    def listModelInvocationJobsPaginated(
        request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListModelInvocationJobsRequest,
      ListModelInvocationJobsResponse
    ]("listModelInvocationJobs", api.listModelInvocationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.ListModelInvocationJobsResponse.wrap)
      .provideEnvironment(r)
    def createModelImportJob(
        request: zio.aws.bedrock.model.CreateModelImportJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateModelImportJobRequest,
      CreateModelImportJobResponse
    ]("createModelImportJob", api.createModelImportJob)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.CreateModelImportJobResponse.wrap)
      .provideEnvironment(r)
    def createEvaluationJob(
        request: zio.aws.bedrock.model.CreateEvaluationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEvaluationJobRequest,
      CreateEvaluationJobResponse
    ]("createEvaluationJob", api.createEvaluationJob)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.CreateEvaluationJobResponse.wrap)
      .provideEnvironment(r)
    def listEvaluationJobs(
        request: zio.aws.bedrock.model.ListEvaluationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.EvaluationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListEvaluationJobsRequest,
      EvaluationSummary,
      ListEvaluationJobsPublisher
    ]("listEvaluationJobs", api.listEvaluationJobsPaginator, _.jobSummaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.bedrock.model.EvaluationSummary.wrap(item))
      .provideEnvironment(r)
    def listEvaluationJobsPaginated(
        request: zio.aws.bedrock.model.ListEvaluationJobsRequest
    ): IO[AwsError, zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly] =
      asyncRequestResponse[
        ListEvaluationJobsRequest,
        ListEvaluationJobsResponse
      ]("listEvaluationJobs", api.listEvaluationJobs)(request.buildAwsValue())
        .map(zio.aws.bedrock.model.ListEvaluationJobsResponse.wrap)
        .provideEnvironment(r)
    def getModelImportJob(
        request: zio.aws.bedrock.model.GetModelImportJobRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly] =
      asyncRequestResponse[GetModelImportJobRequest, GetModelImportJobResponse](
        "getModelImportJob",
        api.getModelImportJob
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetModelImportJobResponse.wrap)
        .provideEnvironment(r)
    def deleteImportedModel(
        request: zio.aws.bedrock.model.DeleteImportedModelRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.DeleteImportedModelResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteImportedModelRequest,
      DeleteImportedModelResponse
    ]("deleteImportedModel", api.deleteImportedModel)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.DeleteImportedModelResponse.wrap)
      .provideEnvironment(r)
    def getProvisionedModelThroughput(
        request: zio.aws.bedrock.model.GetProvisionedModelThroughputRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly
    ] = asyncRequestResponse[
      GetProvisionedModelThroughputRequest,
      GetProvisionedModelThroughputResponse
    ]("getProvisionedModelThroughput", api.getProvisionedModelThroughput)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.wrap)
      .provideEnvironment(r)
    def createModelCopyJob(
        request: zio.aws.bedrock.model.CreateModelCopyJobRequest
    ): IO[AwsError, zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly] =
      asyncRequestResponse[
        CreateModelCopyJobRequest,
        CreateModelCopyJobResponse
      ]("createModelCopyJob", api.createModelCopyJob)(request.buildAwsValue())
        .map(zio.aws.bedrock.model.CreateModelCopyJobResponse.wrap)
        .provideEnvironment(r)
    def createGuardrailVersion(
        request: zio.aws.bedrock.model.CreateGuardrailVersionRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGuardrailVersionRequest,
      CreateGuardrailVersionResponse
    ]("createGuardrailVersion", api.createGuardrailVersion)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.CreateGuardrailVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteProvisionedModelThroughput(
        request: zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteProvisionedModelThroughputRequest,
      DeleteProvisionedModelThroughputResponse
    ]("deleteProvisionedModelThroughput", api.deleteProvisionedModelThroughput)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.wrap)
      .provideEnvironment(r)
    def createProvisionedModelThroughput(
        request: zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateProvisionedModelThroughputRequest,
      CreateProvisionedModelThroughputResponse
    ]("createProvisionedModelThroughput", api.createProvisionedModelThroughput)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.wrap)
      .provideEnvironment(r)
    def getFoundationModel(
        request: zio.aws.bedrock.model.GetFoundationModelRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly] =
      asyncRequestResponse[
        GetFoundationModelRequest,
        GetFoundationModelResponse
      ]("getFoundationModel", api.getFoundationModel)(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetFoundationModelResponse.wrap)
        .provideEnvironment(r)
    def updateProvisionedModelThroughput(
        request: zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateProvisionedModelThroughputRequest,
      UpdateProvisionedModelThroughputResponse
    ]("updateProvisionedModelThroughput", api.updateProvisionedModelThroughput)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.wrap)
      .provideEnvironment(r)
    def getModelCopyJob(
        request: zio.aws.bedrock.model.GetModelCopyJobRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetModelCopyJobResponse.ReadOnly] =
      asyncRequestResponse[GetModelCopyJobRequest, GetModelCopyJobResponse](
        "getModelCopyJob",
        api.getModelCopyJob
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetModelCopyJobResponse.wrap)
        .provideEnvironment(r)
    def createGuardrail(
        request: zio.aws.bedrock.model.CreateGuardrailRequest
    ): IO[AwsError, zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly] =
      asyncRequestResponse[CreateGuardrailRequest, CreateGuardrailResponse](
        "createGuardrail",
        api.createGuardrail
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.CreateGuardrailResponse.wrap)
        .provideEnvironment(r)
    def getCustomModel(
        request: zio.aws.bedrock.model.GetCustomModelRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly] =
      asyncRequestResponse[GetCustomModelRequest, GetCustomModelResponse](
        "getCustomModel",
        api.getCustomModel
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetCustomModelResponse.wrap)
        .provideEnvironment(r)
    def getModelCustomizationJob(
        request: zio.aws.bedrock.model.GetModelCustomizationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      GetModelCustomizationJobRequest,
      GetModelCustomizationJobResponse
    ]("getModelCustomizationJob", api.getModelCustomizationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.GetModelCustomizationJobResponse.wrap)
      .provideEnvironment(r)
    def deleteModelInvocationLoggingConfiguration(
        request: zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteModelInvocationLoggingConfigurationRequest,
      DeleteModelInvocationLoggingConfigurationResponse
    ](
      "deleteModelInvocationLoggingConfiguration",
      api.deleteModelInvocationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def updateGuardrail(
        request: zio.aws.bedrock.model.UpdateGuardrailRequest
    ): IO[AwsError, zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly] =
      asyncRequestResponse[UpdateGuardrailRequest, UpdateGuardrailResponse](
        "updateGuardrail",
        api.updateGuardrail
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.UpdateGuardrailResponse.wrap)
        .provideEnvironment(r)
    def listGuardrails(
        request: zio.aws.bedrock.model.ListGuardrailsRequest
    ): ZStream[Any, AwsError, zio.aws.bedrock.model.GuardrailSummary.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListGuardrailsRequest,
        GuardrailSummary,
        ListGuardrailsPublisher
      ]("listGuardrails", api.listGuardrailsPaginator, _.guardrails())(
        request.buildAwsValue()
      ).map(item => zio.aws.bedrock.model.GuardrailSummary.wrap(item))
        .provideEnvironment(r)
    def listGuardrailsPaginated(
        request: zio.aws.bedrock.model.ListGuardrailsRequest
    ): IO[AwsError, zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly] =
      asyncRequestResponse[ListGuardrailsRequest, ListGuardrailsResponse](
        "listGuardrails",
        api.listGuardrails
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.ListGuardrailsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.bedrock.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.bedrock.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createModelCustomizationJob(
        request: zio.aws.bedrock.model.CreateModelCustomizationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateModelCustomizationJobRequest,
      CreateModelCustomizationJobResponse
    ]("createModelCustomizationJob", api.createModelCustomizationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.CreateModelCustomizationJobResponse.wrap)
      .provideEnvironment(r)
    def getImportedModel(
        request: zio.aws.bedrock.model.GetImportedModelRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly] =
      asyncRequestResponse[GetImportedModelRequest, GetImportedModelResponse](
        "getImportedModel",
        api.getImportedModel
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetImportedModelResponse.wrap)
        .provideEnvironment(r)
    def listProvisionedModelThroughputs(
        request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListProvisionedModelThroughputsRequest,
      ProvisionedModelSummary,
      ListProvisionedModelThroughputsPublisher
    ](
      "listProvisionedModelThroughputs",
      api.listProvisionedModelThroughputsPaginator,
      _.provisionedModelSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.ProvisionedModelSummary.wrap(item))
      .provideEnvironment(r)
    def listProvisionedModelThroughputsPaginated(
        request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListProvisionedModelThroughputsRequest,
      ListProvisionedModelThroughputsResponse
    ]("listProvisionedModelThroughputs", api.listProvisionedModelThroughputs)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.wrap)
      .provideEnvironment(r)
    def getModelInvocationLoggingConfiguration(
        request: zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetModelInvocationLoggingConfigurationRequest,
      GetModelInvocationLoggingConfigurationResponse
    ](
      "getModelInvocationLoggingConfiguration",
      api.getModelInvocationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteGuardrail(
        request: zio.aws.bedrock.model.DeleteGuardrailRequest
    ): IO[AwsError, zio.aws.bedrock.model.DeleteGuardrailResponse.ReadOnly] =
      asyncRequestResponse[DeleteGuardrailRequest, DeleteGuardrailResponse](
        "deleteGuardrail",
        api.deleteGuardrail
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.DeleteGuardrailResponse.wrap)
        .provideEnvironment(r)
    def getEvaluationJob(
        request: zio.aws.bedrock.model.GetEvaluationJobRequest
    ): IO[AwsError, zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly] =
      asyncRequestResponse[GetEvaluationJobRequest, GetEvaluationJobResponse](
        "getEvaluationJob",
        api.getEvaluationJob
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.GetEvaluationJobResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.bedrock.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def stopEvaluationJob(
        request: zio.aws.bedrock.model.StopEvaluationJobRequest
    ): IO[AwsError, zio.aws.bedrock.model.StopEvaluationJobResponse.ReadOnly] =
      asyncRequestResponse[StopEvaluationJobRequest, StopEvaluationJobResponse](
        "stopEvaluationJob",
        api.stopEvaluationJob
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.StopEvaluationJobResponse.wrap)
        .provideEnvironment(r)
    def listImportedModels(
        request: zio.aws.bedrock.model.ListImportedModelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ImportedModelSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListImportedModelsRequest,
      ImportedModelSummary,
      ListImportedModelsPublisher
    ](
      "listImportedModels",
      api.listImportedModelsPaginator,
      _.modelSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.ImportedModelSummary.wrap(item))
      .provideEnvironment(r)
    def listImportedModelsPaginated(
        request: zio.aws.bedrock.model.ListImportedModelsRequest
    ): IO[AwsError, zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly] =
      asyncRequestResponse[
        ListImportedModelsRequest,
        ListImportedModelsResponse
      ]("listImportedModels", api.listImportedModels)(request.buildAwsValue())
        .map(zio.aws.bedrock.model.ListImportedModelsResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.bedrock.model.TagResourceRequest
    ): IO[AwsError, zio.aws.bedrock.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listModelCustomizationJobs(
        request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListModelCustomizationJobsRequest,
      ModelCustomizationJobSummary,
      ListModelCustomizationJobsPublisher
    ](
      "listModelCustomizationJobs",
      api.listModelCustomizationJobsPaginator,
      _.modelCustomizationJobSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.bedrock.model.ModelCustomizationJobSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listModelCustomizationJobsPaginated(
        request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListModelCustomizationJobsRequest,
      ListModelCustomizationJobsResponse
    ]("listModelCustomizationJobs", api.listModelCustomizationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.ListModelCustomizationJobsResponse.wrap)
      .provideEnvironment(r)
    def listModelCopyJobs(
        request: zio.aws.bedrock.model.ListModelCopyJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListModelCopyJobsRequest,
      ModelCopyJobSummary,
      ListModelCopyJobsPublisher
    ](
      "listModelCopyJobs",
      api.listModelCopyJobsPaginator,
      _.modelCopyJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.ModelCopyJobSummary.wrap(item))
      .provideEnvironment(r)
    def listModelCopyJobsPaginated(
        request: zio.aws.bedrock.model.ListModelCopyJobsRequest
    ): IO[AwsError, zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly] =
      asyncRequestResponse[ListModelCopyJobsRequest, ListModelCopyJobsResponse](
        "listModelCopyJobs",
        api.listModelCopyJobs
      )(request.buildAwsValue())
        .map(zio.aws.bedrock.model.ListModelCopyJobsResponse.wrap)
        .provideEnvironment(r)
    def listInferenceProfiles(
        request: zio.aws.bedrock.model.ListInferenceProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListInferenceProfilesRequest,
      InferenceProfileSummary,
      ListInferenceProfilesPublisher
    ](
      "listInferenceProfiles",
      api.listInferenceProfilesPaginator,
      _.inferenceProfileSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.InferenceProfileSummary.wrap(item))
      .provideEnvironment(r)
    def listInferenceProfilesPaginated(
        request: zio.aws.bedrock.model.ListInferenceProfilesRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListInferenceProfilesRequest,
      ListInferenceProfilesResponse
    ]("listInferenceProfiles", api.listInferenceProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.ListInferenceProfilesResponse.wrap)
      .provideEnvironment(r)
    def stopModelCustomizationJob(
        request: zio.aws.bedrock.model.StopModelCustomizationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.StopModelCustomizationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StopModelCustomizationJobRequest,
      StopModelCustomizationJobResponse
    ]("stopModelCustomizationJob", api.stopModelCustomizationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.StopModelCustomizationJobResponse.wrap)
      .provideEnvironment(r)
    def listModelImportJobs(
        request: zio.aws.bedrock.model.ListModelImportJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListModelImportJobsRequest,
      ModelImportJobSummary,
      ListModelImportJobsPublisher
    ](
      "listModelImportJobs",
      api.listModelImportJobsPaginator,
      _.modelImportJobSummaries()
    )(request.buildAwsValue())
      .map(item => zio.aws.bedrock.model.ModelImportJobSummary.wrap(item))
      .provideEnvironment(r)
    def listModelImportJobsPaginated(
        request: zio.aws.bedrock.model.ListModelImportJobsRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListModelImportJobsRequest,
      ListModelImportJobsResponse
    ]("listModelImportJobs", api.listModelImportJobs)(request.buildAwsValue())
      .map(zio.aws.bedrock.model.ListModelImportJobsResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteEvaluationJob(
        request: zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDeleteEvaluationJobRequest,
      BatchDeleteEvaluationJobResponse
    ]("batchDeleteEvaluationJob", api.batchDeleteEvaluationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.wrap)
      .provideEnvironment(r)
    def getModelInvocationJob(
        request: zio.aws.bedrock.model.GetModelInvocationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      GetModelInvocationJobRequest,
      GetModelInvocationJobResponse
    ]("getModelInvocationJob", api.getModelInvocationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.GetModelInvocationJobResponse.wrap)
      .provideEnvironment(r)
    def stopModelInvocationJob(
        request: zio.aws.bedrock.model.StopModelInvocationJobRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.StopModelInvocationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      StopModelInvocationJobRequest,
      StopModelInvocationJobResponse
    ]("stopModelInvocationJob", api.stopModelInvocationJob)(
      request.buildAwsValue()
    ).map(zio.aws.bedrock.model.StopModelInvocationJobResponse.wrap)
      .provideEnvironment(r)
    def putModelInvocationLoggingConfiguration(
        request: zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutModelInvocationLoggingConfigurationRequest,
      PutModelInvocationLoggingConfigurationResponse
    ](
      "putModelInvocationLoggingConfiguration",
      api.putModelInvocationLoggingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def getGuardrail(
      request: zio.aws.bedrock.model.GetGuardrailRequest
  ): ZIO[zio.aws.bedrock.Bedrock, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getGuardrail(request))
  def listFoundationModels(
      request: zio.aws.bedrock.model.ListFoundationModelsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFoundationModels(request))
  def getInferenceProfile(
      request: zio.aws.bedrock.model.GetInferenceProfileRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInferenceProfile(request))
  def createModelInvocationJob(
      request: zio.aws.bedrock.model.CreateModelInvocationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelInvocationJob(request))
  def deleteCustomModel(
      request: zio.aws.bedrock.model.DeleteCustomModelRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.DeleteCustomModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomModel(request))
  def listCustomModels(
      request: zio.aws.bedrock.model.ListCustomModelsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CustomModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCustomModels(request))
  def listCustomModelsPaginated(
      request: zio.aws.bedrock.model.ListCustomModelsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListCustomModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCustomModelsPaginated(request))
  def listModelInvocationJobs(
      request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelInvocationJobs(request))
  def listModelInvocationJobsPaginated(
      request: zio.aws.bedrock.model.ListModelInvocationJobsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelInvocationJobsPaginated(request))
  def createModelImportJob(
      request: zio.aws.bedrock.model.CreateModelImportJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelImportJob(request))
  def createEvaluationJob(
      request: zio.aws.bedrock.model.CreateEvaluationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEvaluationJob(request))
  def listEvaluationJobs(
      request: zio.aws.bedrock.model.ListEvaluationJobsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.EvaluationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEvaluationJobs(request))
  def listEvaluationJobsPaginated(
      request: zio.aws.bedrock.model.ListEvaluationJobsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEvaluationJobsPaginated(request))
  def getModelImportJob(
      request: zio.aws.bedrock.model.GetModelImportJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelImportJob(request))
  def deleteImportedModel(
      request: zio.aws.bedrock.model.DeleteImportedModelRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.DeleteImportedModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImportedModel(request))
  def getProvisionedModelThroughput(
      request: zio.aws.bedrock.model.GetProvisionedModelThroughputRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProvisionedModelThroughput(request))
  def createModelCopyJob(
      request: zio.aws.bedrock.model.CreateModelCopyJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelCopyJob(request))
  def createGuardrailVersion(
      request: zio.aws.bedrock.model.CreateGuardrailVersionRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGuardrailVersion(request))
  def deleteProvisionedModelThroughput(
      request: zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProvisionedModelThroughput(request))
  def createProvisionedModelThroughput(
      request: zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProvisionedModelThroughput(request))
  def getFoundationModel(
      request: zio.aws.bedrock.model.GetFoundationModelRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFoundationModel(request))
  def updateProvisionedModelThroughput(
      request: zio.aws.bedrock.model.UpdateProvisionedModelThroughputRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProvisionedModelThroughput(request))
  def getModelCopyJob(
      request: zio.aws.bedrock.model.GetModelCopyJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetModelCopyJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelCopyJob(request))
  def createGuardrail(
      request: zio.aws.bedrock.model.CreateGuardrailRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGuardrail(request))
  def getCustomModel(request: zio.aws.bedrock.model.GetCustomModelRequest): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCustomModel(request))
  def getModelCustomizationJob(
      request: zio.aws.bedrock.model.GetModelCustomizationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelCustomizationJob(request))
  def deleteModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteModelInvocationLoggingConfiguration(request))
  def updateGuardrail(
      request: zio.aws.bedrock.model.UpdateGuardrailRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGuardrail(request))
  def listGuardrails(
      request: zio.aws.bedrock.model.ListGuardrailsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GuardrailSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listGuardrails(request))
  def listGuardrailsPaginated(
      request: zio.aws.bedrock.model.ListGuardrailsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGuardrailsPaginated(request))
  def untagResource(request: zio.aws.bedrock.model.UntagResourceRequest): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createModelCustomizationJob(
      request: zio.aws.bedrock.model.CreateModelCustomizationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModelCustomizationJob(request))
  def getImportedModel(
      request: zio.aws.bedrock.model.GetImportedModelRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImportedModel(request))
  def listProvisionedModelThroughputs(
      request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProvisionedModelThroughputs(request))
  def listProvisionedModelThroughputsPaginated(
      request: zio.aws.bedrock.model.ListProvisionedModelThroughputsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisionedModelThroughputsPaginated(request))
  def getModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelInvocationLoggingConfiguration(request))
  def deleteGuardrail(
      request: zio.aws.bedrock.model.DeleteGuardrailRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.DeleteGuardrailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGuardrail(request))
  def getEvaluationJob(
      request: zio.aws.bedrock.model.GetEvaluationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvaluationJob(request))
  def listTagsForResource(
      request: zio.aws.bedrock.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def stopEvaluationJob(
      request: zio.aws.bedrock.model.StopEvaluationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.StopEvaluationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopEvaluationJob(request))
  def listImportedModels(
      request: zio.aws.bedrock.model.ListImportedModelsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ImportedModelSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImportedModels(request))
  def listImportedModelsPaginated(
      request: zio.aws.bedrock.model.ListImportedModelsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImportedModelsPaginated(request))
  def tagResource(request: zio.aws.bedrock.model.TagResourceRequest): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listModelCustomizationJobs(
      request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelCustomizationJobs(request))
  def listModelCustomizationJobsPaginated(
      request: zio.aws.bedrock.model.ListModelCustomizationJobsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelCustomizationJobsPaginated(request))
  def listModelCopyJobs(
      request: zio.aws.bedrock.model.ListModelCopyJobsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelCopyJobs(request))
  def listModelCopyJobsPaginated(
      request: zio.aws.bedrock.model.ListModelCopyJobsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelCopyJobsPaginated(request))
  def listInferenceProfiles(
      request: zio.aws.bedrock.model.ListInferenceProfilesRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInferenceProfiles(request))
  def listInferenceProfilesPaginated(
      request: zio.aws.bedrock.model.ListInferenceProfilesRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInferenceProfilesPaginated(request))
  def stopModelCustomizationJob(
      request: zio.aws.bedrock.model.StopModelCustomizationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.StopModelCustomizationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopModelCustomizationJob(request))
  def listModelImportJobs(
      request: zio.aws.bedrock.model.ListModelImportJobsRequest
  ): ZStream[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listModelImportJobs(request))
  def listModelImportJobsPaginated(
      request: zio.aws.bedrock.model.ListModelImportJobsRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listModelImportJobsPaginated(request))
  def batchDeleteEvaluationJob(
      request: zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteEvaluationJob(request))
  def getModelInvocationJob(
      request: zio.aws.bedrock.model.GetModelInvocationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelInvocationJob(request))
  def stopModelInvocationJob(
      request: zio.aws.bedrock.model.StopModelInvocationJobRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.StopModelInvocationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopModelInvocationJob(request))
  def putModelInvocationLoggingConfiguration(
      request: zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationRequest
  ): ZIO[
    zio.aws.bedrock.Bedrock,
    AwsError,
    zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putModelInvocationLoggingConfiguration(request))
}
