package zio.aws.bedrock
import zio.aws.bedrock.model.GetGuardrailResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.bedrock.model.{
  ListInferenceProfilesRequest,
  GetEvaluationJobRequest,
  StopEvaluationJobRequest,
  ListModelCopyJobsRequest,
  DeleteGuardrailRequest,
  CreateModelImportJobRequest,
  DeleteCustomModelRequest,
  CreateModelCopyJobRequest,
  GetModelCustomizationJobRequest,
  StopModelInvocationJobRequest,
  ListGuardrailsRequest,
  DeleteProvisionedModelThroughputRequest,
  CreateGuardrailRequest,
  UpdateGuardrailRequest,
  DeleteModelInvocationLoggingConfigurationRequest,
  CreateProvisionedModelThroughputRequest,
  BatchDeleteEvaluationJobRequest,
  ListTagsForResourceRequest,
  GetModelInvocationLoggingConfigurationRequest,
  GetImportedModelRequest,
  GetInferenceProfileRequest,
  PutModelInvocationLoggingConfigurationRequest,
  CreateGuardrailVersionRequest,
  ListModelCustomizationJobsRequest,
  ListModelImportJobsRequest,
  GetModelInvocationJobRequest,
  StopModelCustomizationJobRequest,
  ListProvisionedModelThroughputsRequest,
  ListEvaluationJobsRequest,
  GetGuardrailRequest,
  GetFoundationModelRequest,
  ListFoundationModelsRequest,
  UntagResourceRequest,
  GetModelCopyJobRequest,
  GetModelImportJobRequest,
  ListModelInvocationJobsRequest,
  GetProvisionedModelThroughputRequest,
  ListImportedModelsRequest,
  UpdateProvisionedModelThroughputRequest,
  GetCustomModelRequest,
  CreateEvaluationJobRequest,
  CreateModelInvocationJobRequest,
  DeleteImportedModelRequest,
  ListCustomModelsRequest,
  CreateModelCustomizationJobRequest,
  TagResourceRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object BedrockMock extends Mock[Bedrock] {
  object GetGuardrail extends Effect[GetGuardrailRequest, AwsError, ReadOnly]
  object ListFoundationModels
      extends Effect[
        ListFoundationModelsRequest,
        AwsError,
        zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly
      ]
  object GetInferenceProfile
      extends Effect[
        GetInferenceProfileRequest,
        AwsError,
        zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly
      ]
  object CreateModelInvocationJob
      extends Effect[
        CreateModelInvocationJobRequest,
        AwsError,
        zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly
      ]
  object DeleteCustomModel
      extends Effect[
        DeleteCustomModelRequest,
        AwsError,
        zio.aws.bedrock.model.DeleteCustomModelResponse.ReadOnly
      ]
  object ListCustomModels
      extends Stream[
        ListCustomModelsRequest,
        AwsError,
        zio.aws.bedrock.model.CustomModelSummary.ReadOnly
      ]
  object ListCustomModelsPaginated
      extends Effect[
        ListCustomModelsRequest,
        AwsError,
        zio.aws.bedrock.model.ListCustomModelsResponse.ReadOnly
      ]
  object ListModelInvocationJobs
      extends Stream[
        ListModelInvocationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
      ]
  object ListModelInvocationJobsPaginated
      extends Effect[
        ListModelInvocationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly
      ]
  object CreateModelImportJob
      extends Effect[
        CreateModelImportJobRequest,
        AwsError,
        zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly
      ]
  object CreateEvaluationJob
      extends Effect[
        CreateEvaluationJobRequest,
        AwsError,
        zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly
      ]
  object ListEvaluationJobs
      extends Stream[
        ListEvaluationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.EvaluationSummary.ReadOnly
      ]
  object ListEvaluationJobsPaginated
      extends Effect[
        ListEvaluationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly
      ]
  object GetModelImportJob
      extends Effect[
        GetModelImportJobRequest,
        AwsError,
        zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly
      ]
  object DeleteImportedModel
      extends Effect[
        DeleteImportedModelRequest,
        AwsError,
        zio.aws.bedrock.model.DeleteImportedModelResponse.ReadOnly
      ]
  object GetProvisionedModelThroughput
      extends Effect[
        GetProvisionedModelThroughputRequest,
        AwsError,
        zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly
      ]
  object CreateModelCopyJob
      extends Effect[
        CreateModelCopyJobRequest,
        AwsError,
        zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly
      ]
  object CreateGuardrailVersion
      extends Effect[
        CreateGuardrailVersionRequest,
        AwsError,
        zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly
      ]
  object DeleteProvisionedModelThroughput
      extends Effect[
        DeleteProvisionedModelThroughputRequest,
        AwsError,
        zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.ReadOnly
      ]
  object CreateProvisionedModelThroughput
      extends Effect[
        CreateProvisionedModelThroughputRequest,
        AwsError,
        zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly
      ]
  object GetFoundationModel
      extends Effect[
        GetFoundationModelRequest,
        AwsError,
        zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly
      ]
  object UpdateProvisionedModelThroughput
      extends Effect[
        UpdateProvisionedModelThroughputRequest,
        AwsError,
        zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.ReadOnly
      ]
  object GetModelCopyJob
      extends Effect[
        GetModelCopyJobRequest,
        AwsError,
        zio.aws.bedrock.model.GetModelCopyJobResponse.ReadOnly
      ]
  object CreateGuardrail
      extends Effect[
        CreateGuardrailRequest,
        AwsError,
        zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly
      ]
  object GetCustomModel
      extends Effect[
        GetCustomModelRequest,
        AwsError,
        zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly
      ]
  object GetModelCustomizationJob
      extends Effect[
        GetModelCustomizationJobRequest,
        AwsError,
        zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly
      ]
  object DeleteModelInvocationLoggingConfiguration
      extends Effect[
        DeleteModelInvocationLoggingConfigurationRequest,
        AwsError,
        zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.ReadOnly
      ]
  object UpdateGuardrail
      extends Effect[
        UpdateGuardrailRequest,
        AwsError,
        zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly
      ]
  object ListGuardrails
      extends Stream[
        ListGuardrailsRequest,
        AwsError,
        zio.aws.bedrock.model.GuardrailSummary.ReadOnly
      ]
  object ListGuardrailsPaginated
      extends Effect[
        ListGuardrailsRequest,
        AwsError,
        zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.bedrock.model.UntagResourceResponse.ReadOnly
      ]
  object CreateModelCustomizationJob
      extends Effect[
        CreateModelCustomizationJobRequest,
        AwsError,
        zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly
      ]
  object GetImportedModel
      extends Effect[
        GetImportedModelRequest,
        AwsError,
        zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly
      ]
  object ListProvisionedModelThroughputs
      extends Stream[
        ListProvisionedModelThroughputsRequest,
        AwsError,
        zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
      ]
  object ListProvisionedModelThroughputsPaginated
      extends Effect[
        ListProvisionedModelThroughputsRequest,
        AwsError,
        zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly
      ]
  object GetModelInvocationLoggingConfiguration
      extends Effect[
        GetModelInvocationLoggingConfigurationRequest,
        AwsError,
        zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly
      ]
  object DeleteGuardrail
      extends Effect[
        DeleteGuardrailRequest,
        AwsError,
        zio.aws.bedrock.model.DeleteGuardrailResponse.ReadOnly
      ]
  object GetEvaluationJob
      extends Effect[
        GetEvaluationJobRequest,
        AwsError,
        zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.bedrock.model.ListTagsForResourceResponse.ReadOnly
      ]
  object StopEvaluationJob
      extends Effect[
        StopEvaluationJobRequest,
        AwsError,
        zio.aws.bedrock.model.StopEvaluationJobResponse.ReadOnly
      ]
  object ListImportedModels
      extends Stream[
        ListImportedModelsRequest,
        AwsError,
        zio.aws.bedrock.model.ImportedModelSummary.ReadOnly
      ]
  object ListImportedModelsPaginated
      extends Effect[
        ListImportedModelsRequest,
        AwsError,
        zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.bedrock.model.TagResourceResponse.ReadOnly
      ]
  object ListModelCustomizationJobs
      extends Stream[
        ListModelCustomizationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
      ]
  object ListModelCustomizationJobsPaginated
      extends Effect[
        ListModelCustomizationJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly
      ]
  object ListModelCopyJobs
      extends Stream[
        ListModelCopyJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly
      ]
  object ListModelCopyJobsPaginated
      extends Effect[
        ListModelCopyJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly
      ]
  object ListInferenceProfiles
      extends Stream[
        ListInferenceProfilesRequest,
        AwsError,
        zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
      ]
  object ListInferenceProfilesPaginated
      extends Effect[
        ListInferenceProfilesRequest,
        AwsError,
        zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly
      ]
  object StopModelCustomizationJob
      extends Effect[
        StopModelCustomizationJobRequest,
        AwsError,
        zio.aws.bedrock.model.StopModelCustomizationJobResponse.ReadOnly
      ]
  object ListModelImportJobs
      extends Stream[
        ListModelImportJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
      ]
  object ListModelImportJobsPaginated
      extends Effect[
        ListModelImportJobsRequest,
        AwsError,
        zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly
      ]
  object BatchDeleteEvaluationJob
      extends Effect[
        BatchDeleteEvaluationJobRequest,
        AwsError,
        zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly
      ]
  object GetModelInvocationJob
      extends Effect[
        GetModelInvocationJobRequest,
        AwsError,
        zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly
      ]
  object StopModelInvocationJob
      extends Effect[
        StopModelInvocationJobRequest,
        AwsError,
        zio.aws.bedrock.model.StopModelInvocationJobResponse.ReadOnly
      ]
  object PutModelInvocationLoggingConfiguration
      extends Effect[
        PutModelInvocationLoggingConfigurationRequest,
        AwsError,
        zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Bedrock] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Bedrock] { rts =>
        zio.ZIO.succeed {
          new Bedrock {
            val api: BedrockAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Bedrock = this
            def getGuardrail(
                request: GetGuardrailRequest
            ): IO[AwsError, ReadOnly] = proxy(GetGuardrail, request)
            def listFoundationModels(request: ListFoundationModelsRequest): IO[
              AwsError,
              zio.aws.bedrock.model.ListFoundationModelsResponse.ReadOnly
            ] = proxy(ListFoundationModels, request)
            def getInferenceProfile(request: GetInferenceProfileRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly
            ] = proxy(GetInferenceProfile, request)
            def createModelInvocationJob(
                request: CreateModelInvocationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly
            ] = proxy(CreateModelInvocationJob, request)
            def deleteCustomModel(request: DeleteCustomModelRequest): IO[
              AwsError,
              zio.aws.bedrock.model.DeleteCustomModelResponse.ReadOnly
            ] = proxy(DeleteCustomModel, request)
            def listCustomModels(request: ListCustomModelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.CustomModelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCustomModels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCustomModelsPaginated(request: ListCustomModelsRequest): IO[
              AwsError,
              zio.aws.bedrock.model.ListCustomModelsResponse.ReadOnly
            ] = proxy(ListCustomModelsPaginated, request)
            def listModelInvocationJobs(
                request: ListModelInvocationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ModelInvocationJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelInvocationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelInvocationJobsPaginated(
                request: ListModelInvocationJobsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListModelInvocationJobsResponse.ReadOnly
            ] = proxy(ListModelInvocationJobsPaginated, request)
            def createModelImportJob(request: CreateModelImportJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly
            ] = proxy(CreateModelImportJob, request)
            def createEvaluationJob(request: CreateEvaluationJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly
            ] = proxy(CreateEvaluationJob, request)
            def listEvaluationJobs(request: ListEvaluationJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.EvaluationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEvaluationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEvaluationJobsPaginated(
                request: ListEvaluationJobsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListEvaluationJobsResponse.ReadOnly
            ] = proxy(ListEvaluationJobsPaginated, request)
            def getModelImportJob(request: GetModelImportJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly
            ] = proxy(GetModelImportJob, request)
            def deleteImportedModel(request: DeleteImportedModelRequest): IO[
              AwsError,
              zio.aws.bedrock.model.DeleteImportedModelResponse.ReadOnly
            ] = proxy(DeleteImportedModel, request)
            def getProvisionedModelThroughput(
                request: GetProvisionedModelThroughputRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly
            ] = proxy(GetProvisionedModelThroughput, request)
            def createModelCopyJob(request: CreateModelCopyJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly
            ] = proxy(CreateModelCopyJob, request)
            def createGuardrailVersion(
                request: CreateGuardrailVersionRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly
            ] = proxy(CreateGuardrailVersion, request)
            def deleteProvisionedModelThroughput(
                request: DeleteProvisionedModelThroughputRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.DeleteProvisionedModelThroughputResponse.ReadOnly
            ] = proxy(DeleteProvisionedModelThroughput, request)
            def createProvisionedModelThroughput(
                request: CreateProvisionedModelThroughputRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly
            ] = proxy(CreateProvisionedModelThroughput, request)
            def getFoundationModel(request: GetFoundationModelRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly
            ] = proxy(GetFoundationModel, request)
            def updateProvisionedModelThroughput(
                request: UpdateProvisionedModelThroughputRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.UpdateProvisionedModelThroughputResponse.ReadOnly
            ] = proxy(UpdateProvisionedModelThroughput, request)
            def getModelCopyJob(request: GetModelCopyJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetModelCopyJobResponse.ReadOnly
            ] = proxy(GetModelCopyJob, request)
            def createGuardrail(request: CreateGuardrailRequest): IO[
              AwsError,
              zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly
            ] = proxy(CreateGuardrail, request)
            def getCustomModel(request: GetCustomModelRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly
            ] = proxy(GetCustomModel, request)
            def getModelCustomizationJob(
                request: GetModelCustomizationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly
            ] = proxy(GetModelCustomizationJob, request)
            def deleteModelInvocationLoggingConfiguration(
                request: DeleteModelInvocationLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.DeleteModelInvocationLoggingConfigurationResponse.ReadOnly
            ] = proxy(DeleteModelInvocationLoggingConfiguration, request)
            def updateGuardrail(request: UpdateGuardrailRequest): IO[
              AwsError,
              zio.aws.bedrock.model.UpdateGuardrailResponse.ReadOnly
            ] = proxy(UpdateGuardrail, request)
            def listGuardrails(request: ListGuardrailsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.GuardrailSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGuardrails, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGuardrailsPaginated(request: ListGuardrailsRequest): IO[
              AwsError,
              zio.aws.bedrock.model.ListGuardrailsResponse.ReadOnly
            ] = proxy(ListGuardrailsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.bedrock.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createModelCustomizationJob(
                request: CreateModelCustomizationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly
            ] = proxy(CreateModelCustomizationJob, request)
            def getImportedModel(request: GetImportedModelRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly
            ] = proxy(GetImportedModel, request)
            def listProvisionedModelThroughputs(
                request: ListProvisionedModelThroughputsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ProvisionedModelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProvisionedModelThroughputs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProvisionedModelThroughputsPaginated(
                request: ListProvisionedModelThroughputsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListProvisionedModelThroughputsResponse.ReadOnly
            ] = proxy(ListProvisionedModelThroughputsPaginated, request)
            def getModelInvocationLoggingConfiguration(
                request: GetModelInvocationLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly
            ] = proxy(GetModelInvocationLoggingConfiguration, request)
            def deleteGuardrail(request: DeleteGuardrailRequest): IO[
              AwsError,
              zio.aws.bedrock.model.DeleteGuardrailResponse.ReadOnly
            ] = proxy(DeleteGuardrail, request)
            def getEvaluationJob(request: GetEvaluationJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly
            ] = proxy(GetEvaluationJob, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.bedrock.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def stopEvaluationJob(request: StopEvaluationJobRequest): IO[
              AwsError,
              zio.aws.bedrock.model.StopEvaluationJobResponse.ReadOnly
            ] = proxy(StopEvaluationJob, request)
            def listImportedModels(request: ListImportedModelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ImportedModelSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImportedModels, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImportedModelsPaginated(
                request: ListImportedModelsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListImportedModelsResponse.ReadOnly
            ] = proxy(ListImportedModelsPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.bedrock.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listModelCustomizationJobs(
                request: ListModelCustomizationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ModelCustomizationJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelCustomizationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelCustomizationJobsPaginated(
                request: ListModelCustomizationJobsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListModelCustomizationJobsResponse.ReadOnly
            ] = proxy(ListModelCustomizationJobsPaginated, request)
            def listModelCopyJobs(request: ListModelCopyJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ModelCopyJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelCopyJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelCopyJobsPaginated(
                request: ListModelCopyJobsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListModelCopyJobsResponse.ReadOnly
            ] = proxy(ListModelCopyJobsPaginated, request)
            def listInferenceProfiles(
                request: ListInferenceProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.InferenceProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInferenceProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInferenceProfilesPaginated(
                request: ListInferenceProfilesRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListInferenceProfilesResponse.ReadOnly
            ] = proxy(ListInferenceProfilesPaginated, request)
            def stopModelCustomizationJob(
                request: StopModelCustomizationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.StopModelCustomizationJobResponse.ReadOnly
            ] = proxy(StopModelCustomizationJob, request)
            def listModelImportJobs(
                request: ListModelImportJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.bedrock.model.ModelImportJobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelImportJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelImportJobsPaginated(
                request: ListModelImportJobsRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.ListModelImportJobsResponse.ReadOnly
            ] = proxy(ListModelImportJobsPaginated, request)
            def batchDeleteEvaluationJob(
                request: BatchDeleteEvaluationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly
            ] = proxy(BatchDeleteEvaluationJob, request)
            def getModelInvocationJob(
                request: GetModelInvocationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly
            ] = proxy(GetModelInvocationJob, request)
            def stopModelInvocationJob(
                request: StopModelInvocationJobRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.StopModelInvocationJobResponse.ReadOnly
            ] = proxy(StopModelInvocationJob, request)
            def putModelInvocationLoggingConfiguration(
                request: PutModelInvocationLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.bedrock.model.PutModelInvocationLoggingConfigurationResponse.ReadOnly
            ] = proxy(PutModelInvocationLoggingConfiguration, request)
          }
        }
      }
    }
  }
}
