package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AutomatedEvaluationConfig(
    datasetMetricConfigs: Iterable[
      zio.aws.bedrock.model.EvaluationDatasetMetricConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig = {
    import AutomatedEvaluationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig
      .builder()
      .datasetMetricConfigs(datasetMetricConfigs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly =
    zio.aws.bedrock.model.AutomatedEvaluationConfig.wrap(buildAwsValue())
}
object AutomatedEvaluationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.AutomatedEvaluationConfig =
      zio.aws.bedrock.model.AutomatedEvaluationConfig(datasetMetricConfigs.map {
        item =>
          item.asEditable
      })
    def datasetMetricConfigs
        : List[zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly]
    def getDatasetMetricConfigs: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly
    ]] = ZIO.succeed(datasetMetricConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig
  ) extends zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly {
    override val datasetMetricConfigs
        : List[zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly] =
      impl
        .datasetMetricConfigs()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.EvaluationDatasetMetricConfig.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig
  ): zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly = new Wrapper(
    impl
  )
}
