package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDeleteEvaluationJobError(
    jobIdentifier: EvaluationJobIdentifier,
    code: String,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError = {
    import BatchDeleteEvaluationJobError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError
      .builder()
      .jobIdentifier(
        EvaluationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .code(code: java.lang.String)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly =
    zio.aws.bedrock.model.BatchDeleteEvaluationJobError.wrap(buildAwsValue())
}
object BatchDeleteEvaluationJobError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.BatchDeleteEvaluationJobError =
      zio.aws.bedrock.model.BatchDeleteEvaluationJobError(
        jobIdentifier,
        code,
        message.map(value => value)
      )
    def jobIdentifier: EvaluationJobIdentifier
    def code: String
    def message: Optional[String]
    def getJobIdentifier: ZIO[Any, Nothing, EvaluationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
    def getCode: ZIO[Any, Nothing, String] = ZIO.succeed(code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError
  ) extends zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly {
    override val jobIdentifier: EvaluationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .EvaluationJobIdentifier(impl.jobIdentifier())
    override val code: String = impl.code(): String
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobError
  ): zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly = new Wrapper(
    impl
  )
}
