package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteEvaluationJobItem(
    jobIdentifier: EvaluationJobIdentifier,
    jobStatus: zio.aws.bedrock.model.EvaluationJobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem = {
    import BatchDeleteEvaluationJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem
      .builder()
      .jobIdentifier(
        EvaluationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .jobStatus(jobStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly =
    zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.wrap(buildAwsValue())
}
object BatchDeleteEvaluationJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.BatchDeleteEvaluationJobItem =
      zio.aws.bedrock.model
        .BatchDeleteEvaluationJobItem(jobIdentifier, jobStatus)
    def jobIdentifier: EvaluationJobIdentifier
    def jobStatus: zio.aws.bedrock.model.EvaluationJobStatus
    def getJobIdentifier: ZIO[Any, Nothing, EvaluationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
    def getJobStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationJobStatus] =
      ZIO.succeed(jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem
  ) extends zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly {
    override val jobIdentifier: EvaluationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .EvaluationJobIdentifier(impl.jobIdentifier())
    override val jobStatus: zio.aws.bedrock.model.EvaluationJobStatus =
      zio.aws.bedrock.model.EvaluationJobStatus.wrap(impl.jobStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobItem
  ): zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly = new Wrapper(
    impl
  )
}
