package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteEvaluationJobRequest(
    jobIdentifiers: Iterable[EvaluationJobIdentifier]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest = {
    import BatchDeleteEvaluationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest
      .builder()
      .jobIdentifiers(jobIdentifiers.map { item =>
        EvaluationJobIdentifier.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest.ReadOnly =
    zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest.wrap(buildAwsValue())
}
object BatchDeleteEvaluationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest =
      zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest(jobIdentifiers)
    def jobIdentifiers: List[EvaluationJobIdentifier]
    def getJobIdentifiers: ZIO[Any, Nothing, List[EvaluationJobIdentifier]] =
      ZIO.succeed(jobIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest
  ) extends zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest.ReadOnly {
    override val jobIdentifiers: List[EvaluationJobIdentifier] = impl
      .jobIdentifiers()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.EvaluationJobIdentifier(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobRequest
  ): zio.aws.bedrock.model.BatchDeleteEvaluationJobRequest.ReadOnly =
    new Wrapper(impl)
}
