package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteEvaluationJobResponse(
    errors: Iterable[zio.aws.bedrock.model.BatchDeleteEvaluationJobError],
    evaluationJobs: Iterable[zio.aws.bedrock.model.BatchDeleteEvaluationJobItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse = {
    import BatchDeleteEvaluationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .evaluationJobs(evaluationJobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly =
    zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.wrap(buildAwsValue())
}
object BatchDeleteEvaluationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse =
      zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse(
        errors.map { item =>
          item.asEditable
        },
        evaluationJobs.map { item =>
          item.asEditable
        }
      )
    def errors
        : List[zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly]
    def evaluationJobs
        : List[zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getEvaluationJobs: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly
    ]] = ZIO.succeed(evaluationJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse
  ) extends zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly {
    override val errors
        : List[zio.aws.bedrock.model.BatchDeleteEvaluationJobError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.BatchDeleteEvaluationJobError.wrap(item)
        }
        .toList
    override val evaluationJobs
        : List[zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.ReadOnly] =
      impl
        .evaluationJobs()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.BatchDeleteEvaluationJobItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.BatchDeleteEvaluationJobResponse
  ): zio.aws.bedrock.model.BatchDeleteEvaluationJobResponse.ReadOnly =
    new Wrapper(impl)
}
