package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{RoleArn, LogGroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchConfig(
    logGroupName: LogGroupName,
    roleArn: RoleArn,
    largeDataDeliveryS3Config: Optional[zio.aws.bedrock.model.S3Config] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CloudWatchConfig = {
    import CloudWatchConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CloudWatchConfig
      .builder()
      .logGroupName(LogGroupName.unwrap(logGroupName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        largeDataDeliveryS3Config.map(value => value.buildAwsValue())
      )(_.largeDataDeliveryS3Config)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CloudWatchConfig.ReadOnly =
    zio.aws.bedrock.model.CloudWatchConfig.wrap(buildAwsValue())
}
object CloudWatchConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CloudWatchConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CloudWatchConfig =
      zio.aws.bedrock.model.CloudWatchConfig(
        logGroupName,
        roleArn,
        largeDataDeliveryS3Config.map(value => value.asEditable)
      )
    def logGroupName: LogGroupName
    def roleArn: RoleArn
    def largeDataDeliveryS3Config
        : Optional[zio.aws.bedrock.model.S3Config.ReadOnly]
    def getLogGroupName: ZIO[Any, Nothing, LogGroupName] =
      ZIO.succeed(logGroupName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getLargeDataDeliveryS3Config
        : ZIO[Any, AwsError, zio.aws.bedrock.model.S3Config.ReadOnly] = AwsError
      .unwrapOptionField("largeDataDeliveryS3Config", largeDataDeliveryS3Config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CloudWatchConfig
  ) extends zio.aws.bedrock.model.CloudWatchConfig.ReadOnly {
    override val logGroupName: LogGroupName =
      zio.aws.bedrock.model.primitives.LogGroupName(impl.logGroupName())
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val largeDataDeliveryS3Config
        : Optional[zio.aws.bedrock.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.largeDataDeliveryS3Config())
        .map(value => zio.aws.bedrock.model.S3Config.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CloudWatchConfig
  ): zio.aws.bedrock.model.CloudWatchConfig.ReadOnly = new Wrapper(impl)
}
