package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait CommitmentDuration {
  def unwrap: software.amazon.awssdk.services.bedrock.model.CommitmentDuration
}
object CommitmentDuration {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.CommitmentDuration
  ): zio.aws.bedrock.model.CommitmentDuration = value match {
    case software.amazon.awssdk.services.bedrock.model.CommitmentDuration.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.CommitmentDuration.ONE_MONTH =>
      val r = OneMonth
      r
    case software.amazon.awssdk.services.bedrock.model.CommitmentDuration.SIX_MONTHS =>
      val r = SixMonths
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.CommitmentDuration {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CommitmentDuration =
      software.amazon.awssdk.services.bedrock.model.CommitmentDuration.UNKNOWN_TO_SDK_VERSION
  }
  case object OneMonth extends zio.aws.bedrock.model.CommitmentDuration {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CommitmentDuration =
      software.amazon.awssdk.services.bedrock.model.CommitmentDuration.ONE_MONTH
  }
  case object SixMonths extends zio.aws.bedrock.model.CommitmentDuration {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CommitmentDuration =
      software.amazon.awssdk.services.bedrock.model.CommitmentDuration.SIX_MONTHS
  }
}
