package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  EvaluationJobDescription,
  RoleArn,
  EvaluationJobName,
  IdempotencyToken,
  KmsKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEvaluationJobRequest(
    jobName: EvaluationJobName,
    jobDescription: Optional[EvaluationJobDescription] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    roleArn: RoleArn,
    customerEncryptionKeyId: Optional[KmsKeyId] = Optional.Absent,
    jobTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent,
    evaluationConfig: zio.aws.bedrock.model.EvaluationConfig,
    inferenceConfig: zio.aws.bedrock.model.EvaluationInferenceConfig,
    outputDataConfig: zio.aws.bedrock.model.EvaluationOutputDataConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest = {
    import CreateEvaluationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest
      .builder()
      .jobName(EvaluationJobName.unwrap(jobName): java.lang.String)
      .optionallyWith(
        jobDescription.map(value =>
          EvaluationJobDescription.unwrap(value): java.lang.String
        )
      )(_.jobDescription)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        customerEncryptionKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.customerEncryptionKeyId)
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .evaluationConfig(evaluationConfig.buildAwsValue())
      .inferenceConfig(inferenceConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateEvaluationJobRequest.ReadOnly =
    zio.aws.bedrock.model.CreateEvaluationJobRequest.wrap(buildAwsValue())
}
object CreateEvaluationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateEvaluationJobRequest =
      zio.aws.bedrock.model.CreateEvaluationJobRequest(
        jobName,
        jobDescription.map(value => value),
        clientRequestToken.map(value => value),
        roleArn,
        customerEncryptionKeyId.map(value => value),
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evaluationConfig.asEditable,
        inferenceConfig.asEditable,
        outputDataConfig.asEditable
      )
    def jobName: EvaluationJobName
    def jobDescription: Optional[EvaluationJobDescription]
    def clientRequestToken: Optional[IdempotencyToken]
    def roleArn: RoleArn
    def customerEncryptionKeyId: Optional[KmsKeyId]
    def jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def evaluationConfig: zio.aws.bedrock.model.EvaluationConfig.ReadOnly
    def inferenceConfig
        : zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly
    def outputDataConfig
        : zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly
    def getJobName: ZIO[Any, Nothing, EvaluationJobName] = ZIO.succeed(jobName)
    def getJobDescription: ZIO[Any, AwsError, EvaluationJobDescription] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getCustomerEncryptionKeyId: ZIO[Any, AwsError, KmsKeyId] = AwsError
      .unwrapOptionField("customerEncryptionKeyId", customerEncryptionKeyId)
    def getJobTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("jobTags", jobTags)
    def getEvaluationConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationConfig.ReadOnly] =
      ZIO.succeed(evaluationConfig)
    def getInferenceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly
    ] = ZIO.succeed(inferenceConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest
  ) extends zio.aws.bedrock.model.CreateEvaluationJobRequest.ReadOnly {
    override val jobName: EvaluationJobName =
      zio.aws.bedrock.model.primitives.EvaluationJobName(impl.jobName())
    override val jobDescription: Optional[EvaluationJobDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDescription())
        .map(value =>
          zio.aws.bedrock.model.primitives.EvaluationJobDescription(value)
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val customerEncryptionKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerEncryptionKeyId())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val evaluationConfig
        : zio.aws.bedrock.model.EvaluationConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationConfig.wrap(impl.evaluationConfig())
    override val inferenceConfig
        : zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationInferenceConfig
        .wrap(impl.inferenceConfig())
    override val outputDataConfig
        : zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationOutputDataConfig
        .wrap(impl.outputDataConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobRequest
  ): zio.aws.bedrock.model.CreateEvaluationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
