package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateEvaluationJobResponse(jobArn: EvaluationJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse = {
    import CreateEvaluationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse
      .builder()
      .jobArn(EvaluationJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly =
    zio.aws.bedrock.model.CreateEvaluationJobResponse.wrap(buildAwsValue())
}
object CreateEvaluationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateEvaluationJobResponse =
      zio.aws.bedrock.model.CreateEvaluationJobResponse(jobArn)
    def jobArn: EvaluationJobArn
    def getJobArn: ZIO[Any, Nothing, EvaluationJobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse
  ) extends zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly {
    override val jobArn: EvaluationJobArn =
      zio.aws.bedrock.model.primitives.EvaluationJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateEvaluationJobResponse
  ): zio.aws.bedrock.model.CreateEvaluationJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
