package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailName,
  GuardrailBlockedMessaging,
  GuardrailDescription,
  IdempotencyToken,
  KmsKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGuardrailRequest(
    name: GuardrailName,
    description: Optional[GuardrailDescription] = Optional.Absent,
    topicPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailTopicPolicyConfig
    ] = Optional.Absent,
    contentPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailContentPolicyConfig
    ] = Optional.Absent,
    wordPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailWordPolicyConfig
    ] = Optional.Absent,
    sensitiveInformationPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig
    ] = Optional.Absent,
    contextualGroundingPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig
    ] = Optional.Absent,
    blockedInputMessaging: GuardrailBlockedMessaging,
    blockedOutputsMessaging: GuardrailBlockedMessaging,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest = {
    import CreateGuardrailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest
      .builder()
      .name(GuardrailName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GuardrailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(topicPolicyConfig.map(value => value.buildAwsValue()))(
        _.topicPolicyConfig
      )
      .optionallyWith(contentPolicyConfig.map(value => value.buildAwsValue()))(
        _.contentPolicyConfig
      )
      .optionallyWith(wordPolicyConfig.map(value => value.buildAwsValue()))(
        _.wordPolicyConfig
      )
      .optionallyWith(
        sensitiveInformationPolicyConfig.map(value => value.buildAwsValue())
      )(_.sensitiveInformationPolicyConfig)
      .optionallyWith(
        contextualGroundingPolicyConfig.map(value => value.buildAwsValue())
      )(_.contextualGroundingPolicyConfig)
      .blockedInputMessaging(
        GuardrailBlockedMessaging.unwrap(
          blockedInputMessaging
        ): java.lang.String
      )
      .blockedOutputsMessaging(
        GuardrailBlockedMessaging.unwrap(
          blockedOutputsMessaging
        ): java.lang.String
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateGuardrailRequest.ReadOnly =
    zio.aws.bedrock.model.CreateGuardrailRequest.wrap(buildAwsValue())
}
object CreateGuardrailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateGuardrailRequest =
      zio.aws.bedrock.model.CreateGuardrailRequest(
        name,
        description.map(value => value),
        topicPolicyConfig.map(value => value.asEditable),
        contentPolicyConfig.map(value => value.asEditable),
        wordPolicyConfig.map(value => value.asEditable),
        sensitiveInformationPolicyConfig.map(value => value.asEditable),
        contextualGroundingPolicyConfig.map(value => value.asEditable),
        blockedInputMessaging,
        blockedOutputsMessaging,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def name: GuardrailName
    def description: Optional[GuardrailDescription]
    def topicPolicyConfig
        : Optional[zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly]
    def contentPolicyConfig
        : Optional[zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly]
    def wordPolicyConfig
        : Optional[zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly]
    def sensitiveInformationPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly
    ]
    def contextualGroundingPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly
    ]
    def blockedInputMessaging: GuardrailBlockedMessaging
    def blockedOutputsMessaging: GuardrailBlockedMessaging
    def kmsKeyId: Optional[KmsKeyId]
    def tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[IdempotencyToken]
    def getName: ZIO[Any, Nothing, GuardrailName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, GuardrailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTopicPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("topicPolicyConfig", topicPolicyConfig)
    def getContentPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentPolicyConfig", contentPolicyConfig)
    def getWordPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("wordPolicyConfig", wordPolicyConfig)
    def getSensitiveInformationPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sensitiveInformationPolicyConfig",
      sensitiveInformationPolicyConfig
    )
    def getContextualGroundingPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contextualGroundingPolicyConfig",
      contextualGroundingPolicyConfig
    )
    def getBlockedInputMessaging: ZIO[Any, Nothing, GuardrailBlockedMessaging] =
      ZIO.succeed(blockedInputMessaging)
    def getBlockedOutputsMessaging
        : ZIO[Any, Nothing, GuardrailBlockedMessaging] =
      ZIO.succeed(blockedOutputsMessaging)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest
  ) extends zio.aws.bedrock.model.CreateGuardrailRequest.ReadOnly {
    override val name: GuardrailName =
      zio.aws.bedrock.model.primitives.GuardrailName(impl.name())
    override val description: Optional[GuardrailDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailDescription(value)
        )
    override val topicPolicyConfig
        : Optional[zio.aws.bedrock.model.GuardrailTopicPolicyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicPolicyConfig())
        .map(value =>
          zio.aws.bedrock.model.GuardrailTopicPolicyConfig.wrap(value)
        )
    override val contentPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contentPolicyConfig())
      .map(value =>
        zio.aws.bedrock.model.GuardrailContentPolicyConfig.wrap(value)
      )
    override val wordPolicyConfig
        : Optional[zio.aws.bedrock.model.GuardrailWordPolicyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wordPolicyConfig())
        .map(value =>
          zio.aws.bedrock.model.GuardrailWordPolicyConfig.wrap(value)
        )
    override val sensitiveInformationPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitiveInformationPolicyConfig())
      .map(value =>
        zio.aws.bedrock.model.GuardrailSensitiveInformationPolicyConfig
          .wrap(value)
      )
    override val contextualGroundingPolicyConfig: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contextualGroundingPolicyConfig())
      .map(value =>
        zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig
          .wrap(value)
      )
    override val blockedInputMessaging: GuardrailBlockedMessaging =
      zio.aws.bedrock.model.primitives
        .GuardrailBlockedMessaging(impl.blockedInputMessaging())
    override val blockedOutputsMessaging: GuardrailBlockedMessaging =
      zio.aws.bedrock.model.primitives
        .GuardrailBlockedMessaging(impl.blockedOutputsMessaging())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailRequest
  ): zio.aws.bedrock.model.CreateGuardrailRequest.ReadOnly = new Wrapper(impl)
}
