package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  Timestamp,
  GuardrailDraftVersion,
  GuardrailArn,
  GuardrailId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateGuardrailResponse(
    guardrailId: GuardrailId,
    guardrailArn: GuardrailArn,
    version: GuardrailDraftVersion,
    createdAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse = {
    import CreateGuardrailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse
      .builder()
      .guardrailId(GuardrailId.unwrap(guardrailId): java.lang.String)
      .guardrailArn(GuardrailArn.unwrap(guardrailArn): java.lang.String)
      .version(GuardrailDraftVersion.unwrap(version): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly =
    zio.aws.bedrock.model.CreateGuardrailResponse.wrap(buildAwsValue())
}
object CreateGuardrailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateGuardrailResponse =
      zio.aws.bedrock.model.CreateGuardrailResponse(
        guardrailId,
        guardrailArn,
        version,
        createdAt
      )
    def guardrailId: GuardrailId
    def guardrailArn: GuardrailArn
    def version: GuardrailDraftVersion
    def createdAt: Timestamp
    def getGuardrailId: ZIO[Any, Nothing, GuardrailId] =
      ZIO.succeed(guardrailId)
    def getGuardrailArn: ZIO[Any, Nothing, GuardrailArn] =
      ZIO.succeed(guardrailArn)
    def getVersion: ZIO[Any, Nothing, GuardrailDraftVersion] =
      ZIO.succeed(version)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse
  ) extends zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly {
    override val guardrailId: GuardrailId =
      zio.aws.bedrock.model.primitives.GuardrailId(impl.guardrailId())
    override val guardrailArn: GuardrailArn =
      zio.aws.bedrock.model.primitives.GuardrailArn(impl.guardrailArn())
    override val version: GuardrailDraftVersion =
      zio.aws.bedrock.model.primitives.GuardrailDraftVersion(impl.version())
    override val createdAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.createdAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailResponse
  ): zio.aws.bedrock.model.CreateGuardrailResponse.ReadOnly = new Wrapper(impl)
}
