package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  IdempotencyToken,
  GuardrailDescription,
  GuardrailIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGuardrailVersionRequest(
    guardrailIdentifier: GuardrailIdentifier,
    description: Optional[GuardrailDescription] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest = {
    import CreateGuardrailVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest
      .builder()
      .guardrailIdentifier(
        GuardrailIdentifier.unwrap(guardrailIdentifier): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          GuardrailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateGuardrailVersionRequest.ReadOnly =
    zio.aws.bedrock.model.CreateGuardrailVersionRequest.wrap(buildAwsValue())
}
object CreateGuardrailVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateGuardrailVersionRequest =
      zio.aws.bedrock.model.CreateGuardrailVersionRequest(
        guardrailIdentifier,
        description.map(value => value),
        clientRequestToken.map(value => value)
      )
    def guardrailIdentifier: GuardrailIdentifier
    def description: Optional[GuardrailDescription]
    def clientRequestToken: Optional[IdempotencyToken]
    def getGuardrailIdentifier: ZIO[Any, Nothing, GuardrailIdentifier] =
      ZIO.succeed(guardrailIdentifier)
    def getDescription: ZIO[Any, AwsError, GuardrailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest
  ) extends zio.aws.bedrock.model.CreateGuardrailVersionRequest.ReadOnly {
    override val guardrailIdentifier: GuardrailIdentifier =
      zio.aws.bedrock.model.primitives
        .GuardrailIdentifier(impl.guardrailIdentifier())
    override val description: Optional[GuardrailDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailDescription(value)
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionRequest
  ): zio.aws.bedrock.model.CreateGuardrailVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
