package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{GuardrailNumericalVersion, GuardrailId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateGuardrailVersionResponse(
    guardrailId: GuardrailId,
    version: GuardrailNumericalVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse = {
    import CreateGuardrailVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse
      .builder()
      .guardrailId(GuardrailId.unwrap(guardrailId): java.lang.String)
      .version(GuardrailNumericalVersion.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly =
    zio.aws.bedrock.model.CreateGuardrailVersionResponse.wrap(buildAwsValue())
}
object CreateGuardrailVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateGuardrailVersionResponse =
      zio.aws.bedrock.model.CreateGuardrailVersionResponse(guardrailId, version)
    def guardrailId: GuardrailId
    def version: GuardrailNumericalVersion
    def getGuardrailId: ZIO[Any, Nothing, GuardrailId] =
      ZIO.succeed(guardrailId)
    def getVersion: ZIO[Any, Nothing, GuardrailNumericalVersion] =
      ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse
  ) extends zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly {
    override val guardrailId: GuardrailId =
      zio.aws.bedrock.model.primitives.GuardrailId(impl.guardrailId())
    override val version: GuardrailNumericalVersion =
      zio.aws.bedrock.model.primitives.GuardrailNumericalVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateGuardrailVersionResponse
  ): zio.aws.bedrock.model.CreateGuardrailVersionResponse.ReadOnly =
    new Wrapper(impl)
}
