package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  IdempotencyToken,
  KmsKeyId,
  CustomModelName,
  ModelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelCopyJobRequest(
    sourceModelArn: ModelArn,
    targetModelName: CustomModelName,
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    targetModelTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] =
      Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest = {
    import CreateModelCopyJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest
      .builder()
      .sourceModelArn(ModelArn.unwrap(sourceModelArn): java.lang.String)
      .targetModelName(
        CustomModelName.unwrap(targetModelName): java.lang.String
      )
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        targetModelTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetModelTags)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateModelCopyJobRequest.ReadOnly =
    zio.aws.bedrock.model.CreateModelCopyJobRequest.wrap(buildAwsValue())
}
object CreateModelCopyJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelCopyJobRequest =
      zio.aws.bedrock.model.CreateModelCopyJobRequest(
        sourceModelArn,
        targetModelName,
        modelKmsKeyId.map(value => value),
        targetModelTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value)
      )
    def sourceModelArn: ModelArn
    def targetModelName: CustomModelName
    def modelKmsKeyId: Optional[KmsKeyId]
    def targetModelTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[IdempotencyToken]
    def getSourceModelArn: ZIO[Any, Nothing, ModelArn] =
      ZIO.succeed(sourceModelArn)
    def getTargetModelName: ZIO[Any, Nothing, CustomModelName] =
      ZIO.succeed(targetModelName)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getTargetModelTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("targetModelTags", targetModelTags)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest
  ) extends zio.aws.bedrock.model.CreateModelCopyJobRequest.ReadOnly {
    override val sourceModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.sourceModelArn())
    override val targetModelName: CustomModelName =
      zio.aws.bedrock.model.primitives.CustomModelName(impl.targetModelName())
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val targetModelTags
        : Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetModelTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobRequest
  ): zio.aws.bedrock.model.CreateModelCopyJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
