package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelCopyJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateModelCopyJobResponse(jobArn: ModelCopyJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse = {
    import CreateModelCopyJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse
      .builder()
      .jobArn(ModelCopyJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly =
    zio.aws.bedrock.model.CreateModelCopyJobResponse.wrap(buildAwsValue())
}
object CreateModelCopyJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelCopyJobResponse =
      zio.aws.bedrock.model.CreateModelCopyJobResponse(jobArn)
    def jobArn: ModelCopyJobArn
    def getJobArn: ZIO[Any, Nothing, ModelCopyJobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse
  ) extends zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly {
    override val jobArn: ModelCopyJobArn =
      zio.aws.bedrock.model.primitives.ModelCopyJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCopyJobResponse
  ): zio.aws.bedrock.model.CreateModelCopyJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
