package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  BaseModelIdentifier,
  RoleArn,
  CustomModelName,
  IdempotencyToken,
  JobName,
  KmsKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelCustomizationJobRequest(
    jobName: JobName,
    customModelName: CustomModelName,
    roleArn: RoleArn,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    baseModelIdentifier: BaseModelIdentifier,
    customizationType: Optional[zio.aws.bedrock.model.CustomizationType] =
      Optional.Absent,
    customModelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    jobTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent,
    customModelTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] =
      Optional.Absent,
    trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig,
    validationDataConfig: Optional[zio.aws.bedrock.model.ValidationDataConfig] =
      Optional.Absent,
    outputDataConfig: zio.aws.bedrock.model.OutputDataConfig,
    hyperParameters: Map[String, String],
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest = {
    import CreateModelCustomizationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest
      .builder()
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .customModelName(
        CustomModelName.unwrap(customModelName): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .baseModelIdentifier(
        BaseModelIdentifier.unwrap(baseModelIdentifier): java.lang.String
      )
      .optionallyWith(customizationType.map(value => value.unwrap))(
        _.customizationType
      )
      .optionallyWith(
        customModelKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.customModelKmsKeyId)
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .optionallyWith(
        customModelTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customModelTags)
      .trainingDataConfig(trainingDataConfig.buildAwsValue())
      .optionallyWith(validationDataConfig.map(value => value.buildAwsValue()))(
        _.validationDataConfig
      )
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .hyperParameters(
        hyperParameters
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateModelCustomizationJobRequest.ReadOnly =
    zio.aws.bedrock.model.CreateModelCustomizationJobRequest
      .wrap(buildAwsValue())
}
object CreateModelCustomizationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelCustomizationJobRequest =
      zio.aws.bedrock.model.CreateModelCustomizationJobRequest(
        jobName,
        customModelName,
        roleArn,
        clientRequestToken.map(value => value),
        baseModelIdentifier,
        customizationType.map(value => value),
        customModelKmsKeyId.map(value => value),
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customModelTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trainingDataConfig.asEditable,
        validationDataConfig.map(value => value.asEditable),
        outputDataConfig.asEditable,
        hyperParameters,
        vpcConfig.map(value => value.asEditable)
      )
    def jobName: JobName
    def customModelName: CustomModelName
    def roleArn: RoleArn
    def clientRequestToken: Optional[IdempotencyToken]
    def baseModelIdentifier: BaseModelIdentifier
    def customizationType: Optional[zio.aws.bedrock.model.CustomizationType]
    def customModelKmsKeyId: Optional[KmsKeyId]
    def jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def customModelTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig.ReadOnly
    def validationDataConfig
        : Optional[zio.aws.bedrock.model.ValidationDataConfig.ReadOnly]
    def outputDataConfig: zio.aws.bedrock.model.OutputDataConfig.ReadOnly
    def hyperParameters: Map[String, String]
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getCustomModelName: ZIO[Any, Nothing, CustomModelName] =
      ZIO.succeed(customModelName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getBaseModelIdentifier: ZIO[Any, Nothing, BaseModelIdentifier] =
      ZIO.succeed(baseModelIdentifier)
    def getCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CustomizationType] =
      AwsError.unwrapOptionField("customizationType", customizationType)
    def getCustomModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("customModelKmsKeyId", customModelKmsKeyId)
    def getJobTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("jobTags", jobTags)
    def getCustomModelTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("customModelTags", customModelTags)
    def getTrainingDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.TrainingDataConfig.ReadOnly] =
      ZIO.succeed(trainingDataConfig)
    def getValidationDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.ValidationDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("validationDataConfig", validationDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getHyperParameters: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(hyperParameters)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest
  ) extends zio.aws.bedrock.model.CreateModelCustomizationJobRequest.ReadOnly {
    override val jobName: JobName =
      zio.aws.bedrock.model.primitives.JobName(impl.jobName())
    override val customModelName: CustomModelName =
      zio.aws.bedrock.model.primitives.CustomModelName(impl.customModelName())
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
    override val baseModelIdentifier: BaseModelIdentifier =
      zio.aws.bedrock.model.primitives
        .BaseModelIdentifier(impl.baseModelIdentifier())
    override val customizationType
        : Optional[zio.aws.bedrock.model.CustomizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationType())
        .map(value => zio.aws.bedrock.model.CustomizationType.wrap(value))
    override val customModelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.customModelKmsKeyId())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val customModelTags
        : Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customModelTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val trainingDataConfig
        : zio.aws.bedrock.model.TrainingDataConfig.ReadOnly =
      zio.aws.bedrock.model.TrainingDataConfig.wrap(impl.trainingDataConfig())
    override val validationDataConfig
        : Optional[zio.aws.bedrock.model.ValidationDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationDataConfig())
        .map(value => zio.aws.bedrock.model.ValidationDataConfig.wrap(value))
    override val outputDataConfig
        : zio.aws.bedrock.model.OutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val hyperParameters: Map[String, String] = impl
      .hyperParameters()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobRequest
  ): zio.aws.bedrock.model.CreateModelCustomizationJobRequest.ReadOnly =
    new Wrapper(impl)
}
