package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelCustomizationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateModelCustomizationJobResponse(
    jobArn: ModelCustomizationJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse = {
    import CreateModelCustomizationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse
      .builder()
      .jobArn(ModelCustomizationJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly =
    zio.aws.bedrock.model.CreateModelCustomizationJobResponse
      .wrap(buildAwsValue())
}
object CreateModelCustomizationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelCustomizationJobResponse =
      zio.aws.bedrock.model.CreateModelCustomizationJobResponse(jobArn)
    def jobArn: ModelCustomizationJobArn
    def getJobArn: ZIO[Any, Nothing, ModelCustomizationJobArn] =
      ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse
  ) extends zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly {
    override val jobArn: ModelCustomizationJobArn =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelCustomizationJobResponse
  ): zio.aws.bedrock.model.CreateModelCustomizationJobResponse.ReadOnly =
    new Wrapper(impl)
}
