package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  RoleArn,
  ImportedModelName,
  IdempotencyToken,
  JobName,
  KmsKeyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateModelImportJobRequest(
    jobName: JobName,
    importedModelName: ImportedModelName,
    roleArn: RoleArn,
    modelDataSource: zio.aws.bedrock.model.ModelDataSource,
    jobTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent,
    importedModelTags: Optional[Iterable[zio.aws.bedrock.model.Tag]] =
      Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent,
    importedModelKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest = {
    import CreateModelImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest
      .builder()
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .importedModelName(
        ImportedModelName.unwrap(importedModelName): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .modelDataSource(modelDataSource.buildAwsValue())
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .optionallyWith(
        importedModelTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importedModelTags)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        importedModelKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.importedModelKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateModelImportJobRequest.ReadOnly =
    zio.aws.bedrock.model.CreateModelImportJobRequest.wrap(buildAwsValue())
}
object CreateModelImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelImportJobRequest =
      zio.aws.bedrock.model.CreateModelImportJobRequest(
        jobName,
        importedModelName,
        roleArn,
        modelDataSource.asEditable,
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        importedModelTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        vpcConfig.map(value => value.asEditable),
        importedModelKmsKeyId.map(value => value)
      )
    def jobName: JobName
    def importedModelName: ImportedModelName
    def roleArn: RoleArn
    def modelDataSource: zio.aws.bedrock.model.ModelDataSource.ReadOnly
    def jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def importedModelTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[IdempotencyToken]
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def importedModelKmsKeyId: Optional[KmsKeyId]
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getImportedModelName: ZIO[Any, Nothing, ImportedModelName] =
      ZIO.succeed(importedModelName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getModelDataSource
        : ZIO[Any, Nothing, zio.aws.bedrock.model.ModelDataSource.ReadOnly] =
      ZIO.succeed(modelDataSource)
    def getJobTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("jobTags", jobTags)
    def getImportedModelTags
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("importedModelTags", importedModelTags)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getImportedModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("importedModelKmsKeyId", importedModelKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest
  ) extends zio.aws.bedrock.model.CreateModelImportJobRequest.ReadOnly {
    override val jobName: JobName =
      zio.aws.bedrock.model.primitives.JobName(impl.jobName())
    override val importedModelName: ImportedModelName =
      zio.aws.bedrock.model.primitives
        .ImportedModelName(impl.importedModelName())
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val modelDataSource
        : zio.aws.bedrock.model.ModelDataSource.ReadOnly =
      zio.aws.bedrock.model.ModelDataSource.wrap(impl.modelDataSource())
    override val jobTags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val importedModelTags
        : Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
    override val importedModelKmsKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelKmsKeyId())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelImportJobRequest
  ): zio.aws.bedrock.model.CreateModelImportJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
