package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelImportJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateModelImportJobResponse(jobArn: ModelImportJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse = {
    import CreateModelImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse
      .builder()
      .jobArn(ModelImportJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly =
    zio.aws.bedrock.model.CreateModelImportJobResponse.wrap(buildAwsValue())
}
object CreateModelImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelImportJobResponse =
      zio.aws.bedrock.model.CreateModelImportJobResponse(jobArn)
    def jobArn: ModelImportJobArn
    def getJobArn: ZIO[Any, Nothing, ModelImportJobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse
  ) extends zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly {
    override val jobArn: ModelImportJobArn =
      zio.aws.bedrock.model.primitives.ModelImportJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelImportJobResponse
  ): zio.aws.bedrock.model.CreateModelImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
