package zio.aws.bedrock.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ModelInvocationIdempotencyToken,
  ModelInvocationJobName,
  RoleArn,
  ModelInvocationJobTimeoutDurationInHours,
  ModelId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateModelInvocationJobRequest(
    jobName: ModelInvocationJobName,
    roleArn: RoleArn,
    clientRequestToken: Optional[ModelInvocationIdempotencyToken] =
      Optional.Absent,
    modelId: ModelId,
    inputDataConfig: zio.aws.bedrock.model.ModelInvocationJobInputDataConfig,
    outputDataConfig: zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig,
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent,
    timeoutDurationInHours: Optional[ModelInvocationJobTimeoutDurationInHours] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest = {
    import CreateModelInvocationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest
      .builder()
      .jobName(ModelInvocationJobName.unwrap(jobName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ModelInvocationIdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .modelId(ModelId.unwrap(modelId): java.lang.String)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        timeoutDurationInHours.map(value =>
          ModelInvocationJobTimeoutDurationInHours.unwrap(value): Integer
        )
      )(_.timeoutDurationInHours)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateModelInvocationJobRequest.ReadOnly =
    zio.aws.bedrock.model.CreateModelInvocationJobRequest.wrap(buildAwsValue())
}
object CreateModelInvocationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelInvocationJobRequest =
      zio.aws.bedrock.model.CreateModelInvocationJobRequest(
        jobName,
        roleArn,
        clientRequestToken.map(value => value),
        modelId,
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        vpcConfig.map(value => value.asEditable),
        timeoutDurationInHours.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobName: ModelInvocationJobName
    def roleArn: RoleArn
    def clientRequestToken: Optional[ModelInvocationIdempotencyToken]
    def modelId: ModelId
    def inputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly
    def outputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def timeoutDurationInHours
        : Optional[ModelInvocationJobTimeoutDurationInHours]
    def tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def getJobName: ZIO[Any, Nothing, ModelInvocationJobName] =
      ZIO.succeed(jobName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getClientRequestToken
        : ZIO[Any, AwsError, ModelInvocationIdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getModelId: ZIO[Any, Nothing, ModelId] = ZIO.succeed(modelId)
    def getInputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly
    ] = ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getTimeoutDurationInHours
        : ZIO[Any, AwsError, ModelInvocationJobTimeoutDurationInHours] =
      AwsError.unwrapOptionField(
        "timeoutDurationInHours",
        timeoutDurationInHours
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest
  ) extends zio.aws.bedrock.model.CreateModelInvocationJobRequest.ReadOnly {
    override val jobName: ModelInvocationJobName =
      zio.aws.bedrock.model.primitives.ModelInvocationJobName(impl.jobName())
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val clientRequestToken: Optional[ModelInvocationIdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .ModelInvocationIdempotencyToken(value)
        )
    override val modelId: ModelId =
      zio.aws.bedrock.model.primitives.ModelId(impl.modelId())
    override val inputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly =
      zio.aws.bedrock.model.ModelInvocationJobInputDataConfig
        .wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
    override val timeoutDurationInHours
        : Optional[ModelInvocationJobTimeoutDurationInHours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutDurationInHours())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .ModelInvocationJobTimeoutDurationInHours(value)
        )
    override val tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobRequest
  ): zio.aws.bedrock.model.CreateModelInvocationJobRequest.ReadOnly =
    new Wrapper(impl)
}
