package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelInvocationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateModelInvocationJobResponse(
    jobArn: ModelInvocationJobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse = {
    import CreateModelInvocationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse
      .builder()
      .jobArn(ModelInvocationJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly =
    zio.aws.bedrock.model.CreateModelInvocationJobResponse.wrap(buildAwsValue())
}
object CreateModelInvocationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CreateModelInvocationJobResponse =
      zio.aws.bedrock.model.CreateModelInvocationJobResponse(jobArn)
    def jobArn: ModelInvocationJobArn
    def getJobArn: ZIO[Any, Nothing, ModelInvocationJobArn] =
      ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse
  ) extends zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly {
    override val jobArn: ModelInvocationJobArn =
      zio.aws.bedrock.model.primitives.ModelInvocationJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateModelInvocationJobResponse
  ): zio.aws.bedrock.model.CreateModelInvocationJobResponse.ReadOnly =
    new Wrapper(impl)
}
