package zio.aws.bedrock.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ModelIdentifier,
  ProvisionedModelName,
  PositiveInteger,
  IdempotencyToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateProvisionedModelThroughputRequest(
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    modelUnits: PositiveInteger,
    provisionedModelName: ProvisionedModelName,
    modelId: ModelIdentifier,
    commitmentDuration: Optional[zio.aws.bedrock.model.CommitmentDuration] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.bedrock.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest = {
    import CreateProvisionedModelThroughputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .modelUnits(PositiveInteger.unwrap(modelUnits): Integer)
      .provisionedModelName(
        ProvisionedModelName.unwrap(provisionedModelName): java.lang.String
      )
      .modelId(ModelIdentifier.unwrap(modelId): java.lang.String)
      .optionallyWith(commitmentDuration.map(value => value.unwrap))(
        _.commitmentDuration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest.ReadOnly =
    zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest
      .wrap(buildAwsValue())
}
object CreateProvisionedModelThroughputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest =
      zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest(
        clientRequestToken.map(value => value),
        modelUnits,
        provisionedModelName,
        modelId,
        commitmentDuration.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: Optional[IdempotencyToken]
    def modelUnits: PositiveInteger
    def provisionedModelName: ProvisionedModelName
    def modelId: ModelIdentifier
    def commitmentDuration: Optional[zio.aws.bedrock.model.CommitmentDuration]
    def tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]]
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getModelUnits: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(modelUnits)
    def getProvisionedModelName: ZIO[Any, Nothing, ProvisionedModelName] =
      ZIO.succeed(provisionedModelName)
    def getModelId: ZIO[Any, Nothing, ModelIdentifier] = ZIO.succeed(modelId)
    def getCommitmentDuration
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CommitmentDuration] =
      AwsError.unwrapOptionField("commitmentDuration", commitmentDuration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest
  ) extends zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest.ReadOnly {
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
    override val modelUnits: PositiveInteger =
      zio.aws.bedrock.model.primitives.PositiveInteger(impl.modelUnits())
    override val provisionedModelName: ProvisionedModelName =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelName(impl.provisionedModelName())
    override val modelId: ModelIdentifier =
      zio.aws.bedrock.model.primitives.ModelIdentifier(impl.modelId())
    override val commitmentDuration
        : Optional[zio.aws.bedrock.model.CommitmentDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commitmentDuration())
        .map(value => zio.aws.bedrock.model.CommitmentDuration.wrap(value))
    override val tags: Optional[List[zio.aws.bedrock.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputRequest
  ): zio.aws.bedrock.model.CreateProvisionedModelThroughputRequest.ReadOnly =
    new Wrapper(impl)
}
