package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ProvisionedModelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateProvisionedModelThroughputResponse(
    provisionedModelArn: ProvisionedModelArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse = {
    import CreateProvisionedModelThroughputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse
      .builder()
      .provisionedModelArn(
        ProvisionedModelArn.unwrap(provisionedModelArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly =
    zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse
      .wrap(buildAwsValue())
}
object CreateProvisionedModelThroughputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse =
      zio.aws.bedrock.model
        .CreateProvisionedModelThroughputResponse(provisionedModelArn)
    def provisionedModelArn: ProvisionedModelArn
    def getProvisionedModelArn: ZIO[Any, Nothing, ProvisionedModelArn] =
      ZIO.succeed(provisionedModelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse
  ) extends zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly {
    override val provisionedModelArn: ProvisionedModelArn =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelArn(impl.provisionedModelArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CreateProvisionedModelThroughputResponse
  ): zio.aws.bedrock.model.CreateProvisionedModelThroughputResponse.ReadOnly =
    new Wrapper(impl)
}
