package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  CustomModelName,
  CustomModelArn,
  AccountId,
  ModelArn,
  Timestamp,
  ModelName
}
import scala.jdk.CollectionConverters._
final case class CustomModelSummary(
    modelArn: CustomModelArn,
    modelName: CustomModelName,
    creationTime: Timestamp,
    baseModelArn: ModelArn,
    baseModelName: ModelName,
    customizationType: Optional[zio.aws.bedrock.model.CustomizationType] =
      Optional.Absent,
    ownerAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.CustomModelSummary = {
    import CustomModelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.CustomModelSummary
      .builder()
      .modelArn(CustomModelArn.unwrap(modelArn): java.lang.String)
      .modelName(CustomModelName.unwrap(modelName): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .baseModelArn(ModelArn.unwrap(baseModelArn): java.lang.String)
      .baseModelName(ModelName.unwrap(baseModelName): java.lang.String)
      .optionallyWith(customizationType.map(value => value.unwrap))(
        _.customizationType
      )
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.CustomModelSummary.ReadOnly =
    zio.aws.bedrock.model.CustomModelSummary.wrap(buildAwsValue())
}
object CustomModelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.CustomModelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.CustomModelSummary =
      zio.aws.bedrock.model.CustomModelSummary(
        modelArn,
        modelName,
        creationTime,
        baseModelArn,
        baseModelName,
        customizationType.map(value => value),
        ownerAccountId.map(value => value)
      )
    def modelArn: CustomModelArn
    def modelName: CustomModelName
    def creationTime: Timestamp
    def baseModelArn: ModelArn
    def baseModelName: ModelName
    def customizationType: Optional[zio.aws.bedrock.model.CustomizationType]
    def ownerAccountId: Optional[AccountId]
    def getModelArn: ZIO[Any, Nothing, CustomModelArn] = ZIO.succeed(modelArn)
    def getModelName: ZIO[Any, Nothing, CustomModelName] =
      ZIO.succeed(modelName)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getBaseModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(baseModelArn)
    def getBaseModelName: ZIO[Any, Nothing, ModelName] =
      ZIO.succeed(baseModelName)
    def getCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CustomizationType] =
      AwsError.unwrapOptionField("customizationType", customizationType)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.CustomModelSummary
  ) extends zio.aws.bedrock.model.CustomModelSummary.ReadOnly {
    override val modelArn: CustomModelArn =
      zio.aws.bedrock.model.primitives.CustomModelArn(impl.modelArn())
    override val modelName: CustomModelName =
      zio.aws.bedrock.model.primitives.CustomModelName(impl.modelName())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val baseModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.baseModelArn())
    override val baseModelName: ModelName =
      zio.aws.bedrock.model.primitives.ModelName(impl.baseModelName())
    override val customizationType
        : Optional[zio.aws.bedrock.model.CustomizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationType())
        .map(value => zio.aws.bedrock.model.CustomizationType.wrap(value))
    override val ownerAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccountId())
      .map(value => zio.aws.bedrock.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.CustomModelSummary
  ): zio.aws.bedrock.model.CustomModelSummary.ReadOnly = new Wrapper(impl)
}
