package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait CustomizationType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.CustomizationType
}
object CustomizationType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.CustomizationType
  ): zio.aws.bedrock.model.CustomizationType = value match {
    case software.amazon.awssdk.services.bedrock.model.CustomizationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.CustomizationType.FINE_TUNING =>
      val r = FINE_TUNING
      r
    case software.amazon.awssdk.services.bedrock.model.CustomizationType.CONTINUED_PRE_TRAINING =>
      val r = CONTINUED_PRE_TRAINING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.CustomizationType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CustomizationType =
      software.amazon.awssdk.services.bedrock.model.CustomizationType.UNKNOWN_TO_SDK_VERSION
  }
  case object FINE_TUNING extends zio.aws.bedrock.model.CustomizationType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CustomizationType =
      software.amazon.awssdk.services.bedrock.model.CustomizationType.FINE_TUNING
  }
  case object CONTINUED_PRE_TRAINING
      extends zio.aws.bedrock.model.CustomizationType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.CustomizationType =
      software.amazon.awssdk.services.bedrock.model.CustomizationType.CONTINUED_PRE_TRAINING
  }
}
