package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomModelRequest(modelIdentifier: ModelIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest = {
    import DeleteCustomModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest
      .builder()
      .modelIdentifier(
        ModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.DeleteCustomModelRequest.ReadOnly =
    zio.aws.bedrock.model.DeleteCustomModelRequest.wrap(buildAwsValue())
}
object DeleteCustomModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.DeleteCustomModelRequest =
      zio.aws.bedrock.model.DeleteCustomModelRequest(modelIdentifier)
    def modelIdentifier: ModelIdentifier
    def getModelIdentifier: ZIO[Any, Nothing, ModelIdentifier] =
      ZIO.succeed(modelIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest
  ) extends zio.aws.bedrock.model.DeleteCustomModelRequest.ReadOnly {
    override val modelIdentifier: ModelIdentifier =
      zio.aws.bedrock.model.primitives.ModelIdentifier(impl.modelIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteCustomModelRequest
  ): zio.aws.bedrock.model.DeleteCustomModelRequest.ReadOnly = new Wrapper(impl)
}
