package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailNumericalVersion,
  GuardrailIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteGuardrailRequest(
    guardrailIdentifier: GuardrailIdentifier,
    guardrailVersion: Optional[GuardrailNumericalVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest = {
    import DeleteGuardrailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest
      .builder()
      .guardrailIdentifier(
        GuardrailIdentifier.unwrap(guardrailIdentifier): java.lang.String
      )
      .optionallyWith(
        guardrailVersion.map(value =>
          GuardrailNumericalVersion.unwrap(value): java.lang.String
        )
      )(_.guardrailVersion)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.DeleteGuardrailRequest.ReadOnly =
    zio.aws.bedrock.model.DeleteGuardrailRequest.wrap(buildAwsValue())
}
object DeleteGuardrailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.DeleteGuardrailRequest =
      zio.aws.bedrock.model.DeleteGuardrailRequest(
        guardrailIdentifier,
        guardrailVersion.map(value => value)
      )
    def guardrailIdentifier: GuardrailIdentifier
    def guardrailVersion: Optional[GuardrailNumericalVersion]
    def getGuardrailIdentifier: ZIO[Any, Nothing, GuardrailIdentifier] =
      ZIO.succeed(guardrailIdentifier)
    def getGuardrailVersion: ZIO[Any, AwsError, GuardrailNumericalVersion] =
      AwsError.unwrapOptionField("guardrailVersion", guardrailVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest
  ) extends zio.aws.bedrock.model.DeleteGuardrailRequest.ReadOnly {
    override val guardrailIdentifier: GuardrailIdentifier =
      zio.aws.bedrock.model.primitives
        .GuardrailIdentifier(impl.guardrailIdentifier())
    override val guardrailVersion: Optional[GuardrailNumericalVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardrailVersion())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailNumericalVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteGuardrailRequest
  ): zio.aws.bedrock.model.DeleteGuardrailRequest.ReadOnly = new Wrapper(impl)
}
