package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ImportedModelIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteImportedModelRequest(
    modelIdentifier: ImportedModelIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest = {
    import DeleteImportedModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest
      .builder()
      .modelIdentifier(
        ImportedModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.DeleteImportedModelRequest.ReadOnly =
    zio.aws.bedrock.model.DeleteImportedModelRequest.wrap(buildAwsValue())
}
object DeleteImportedModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.DeleteImportedModelRequest =
      zio.aws.bedrock.model.DeleteImportedModelRequest(modelIdentifier)
    def modelIdentifier: ImportedModelIdentifier
    def getModelIdentifier: ZIO[Any, Nothing, ImportedModelIdentifier] =
      ZIO.succeed(modelIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest
  ) extends zio.aws.bedrock.model.DeleteImportedModelRequest.ReadOnly {
    override val modelIdentifier: ImportedModelIdentifier =
      zio.aws.bedrock.model.primitives
        .ImportedModelIdentifier(impl.modelIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteImportedModelRequest
  ): zio.aws.bedrock.model.DeleteImportedModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
