package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ProvisionedModelId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProvisionedModelThroughputRequest(
    provisionedModelId: ProvisionedModelId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest = {
    import DeleteProvisionedModelThroughputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest
      .builder()
      .provisionedModelId(
        ProvisionedModelId.unwrap(provisionedModelId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest.ReadOnly =
    zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest
      .wrap(buildAwsValue())
}
object DeleteProvisionedModelThroughputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest =
      zio.aws.bedrock.model
        .DeleteProvisionedModelThroughputRequest(provisionedModelId)
    def provisionedModelId: ProvisionedModelId
    def getProvisionedModelId: ZIO[Any, Nothing, ProvisionedModelId] =
      ZIO.succeed(provisionedModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest
  ) extends zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest.ReadOnly {
    override val provisionedModelId: ProvisionedModelId =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelId(impl.provisionedModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.DeleteProvisionedModelThroughputRequest
  ): zio.aws.bedrock.model.DeleteProvisionedModelThroughputRequest.ReadOnly =
    new Wrapper(impl)
}
