package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  EvaluationModelInferenceParams,
  EvaluationModelIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EvaluationBedrockModel(
    modelIdentifier: EvaluationModelIdentifier,
    inferenceParams: EvaluationModelInferenceParams
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel = {
    import EvaluationBedrockModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel
      .builder()
      .modelIdentifier(
        EvaluationModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .inferenceParams(
        EvaluationModelInferenceParams.unwrap(inferenceParams): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly =
    zio.aws.bedrock.model.EvaluationBedrockModel.wrap(buildAwsValue())
}
object EvaluationBedrockModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationBedrockModel =
      zio.aws.bedrock.model
        .EvaluationBedrockModel(modelIdentifier, inferenceParams)
    def modelIdentifier: EvaluationModelIdentifier
    def inferenceParams: EvaluationModelInferenceParams
    def getModelIdentifier: ZIO[Any, Nothing, EvaluationModelIdentifier] =
      ZIO.succeed(modelIdentifier)
    def getInferenceParams: ZIO[Any, Nothing, EvaluationModelInferenceParams] =
      ZIO.succeed(inferenceParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel
  ) extends zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly {
    override val modelIdentifier: EvaluationModelIdentifier =
      zio.aws.bedrock.model.primitives
        .EvaluationModelIdentifier(impl.modelIdentifier())
    override val inferenceParams: EvaluationModelInferenceParams =
      zio.aws.bedrock.model.primitives
        .EvaluationModelInferenceParams(impl.inferenceParams())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationBedrockModel
  ): zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly = new Wrapper(impl)
}
