package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationConfig(
    automated: Optional[zio.aws.bedrock.model.AutomatedEvaluationConfig] =
      Optional.Absent,
    human: Optional[zio.aws.bedrock.model.HumanEvaluationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationConfig = {
    import EvaluationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationConfig
      .builder()
      .optionallyWith(automated.map(value => value.buildAwsValue()))(
        _.automated
      )
      .optionallyWith(human.map(value => value.buildAwsValue()))(_.human)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationConfig.ReadOnly =
    zio.aws.bedrock.model.EvaluationConfig.wrap(buildAwsValue())
}
object EvaluationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationConfig =
      zio.aws.bedrock.model.EvaluationConfig(
        automated.map(value => value.asEditable),
        human.map(value => value.asEditable)
      )
    def automated
        : Optional[zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly]
    def human: Optional[zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly]
    def getAutomated: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("automated", automated)
    def getHuman: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("human", human)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationConfig
  ) extends zio.aws.bedrock.model.EvaluationConfig.ReadOnly {
    override val automated
        : Optional[zio.aws.bedrock.model.AutomatedEvaluationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automated())
        .map(value =>
          zio.aws.bedrock.model.AutomatedEvaluationConfig.wrap(value)
        )
    override val human
        : Optional[zio.aws.bedrock.model.HumanEvaluationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.human())
        .map(value => zio.aws.bedrock.model.HumanEvaluationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationConfig
  ): zio.aws.bedrock.model.EvaluationConfig.ReadOnly = new Wrapper(impl)
}
