package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationDatasetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationDataset(
    name: EvaluationDatasetName,
    datasetLocation: Optional[zio.aws.bedrock.model.EvaluationDatasetLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationDataset = {
    import EvaluationDataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationDataset
      .builder()
      .name(EvaluationDatasetName.unwrap(name): java.lang.String)
      .optionallyWith(datasetLocation.map(value => value.buildAwsValue()))(
        _.datasetLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationDataset.ReadOnly =
    zio.aws.bedrock.model.EvaluationDataset.wrap(buildAwsValue())
}
object EvaluationDataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationDataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationDataset =
      zio.aws.bedrock.model
        .EvaluationDataset(name, datasetLocation.map(value => value.asEditable))
    def name: EvaluationDatasetName
    def datasetLocation
        : Optional[zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly]
    def getName: ZIO[Any, Nothing, EvaluationDatasetName] = ZIO.succeed(name)
    def getDatasetLocation: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly
    ] = AwsError.unwrapOptionField("datasetLocation", datasetLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDataset
  ) extends zio.aws.bedrock.model.EvaluationDataset.ReadOnly {
    override val name: EvaluationDatasetName =
      zio.aws.bedrock.model.primitives.EvaluationDatasetName(impl.name())
    override val datasetLocation
        : Optional[zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetLocation())
        .map(value =>
          zio.aws.bedrock.model.EvaluationDatasetLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDataset
  ): zio.aws.bedrock.model.EvaluationDataset.ReadOnly = new Wrapper(impl)
}
